// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



/**
 * Configuration information for delivery of dataset contents to Amazon Simple Storage Service (Amazon S3).
 */
class S3DestinationConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The name of the S3 bucket to which dataset contents are delivered.
     */
    val bucket: String? = builder.bucket
    /**
     * Configuration information for coordination with Glue, a fully managed extract, transform
     * and load (ETL) service.
     */
    val glueConfiguration: GlueConfiguration? = builder.glueConfiguration
    /**
     * The key of the dataset contents object in an S3 bucket. Each object has a key that is a
     * unique identifier. Each object has exactly one key.
     * You can create a unique key with the following options:
     * Use !{iotanalytics:scheduleTime} to insert the time of a scheduled SQL
     * query run.
     * Use !{iotanalytics:versionId} to insert a unique hash that identifies a
     * dataset content.
     * Use !{iotanalytics:creationTime} to insert the creation time of a dataset
     * content.
     * The following example creates a unique key for a CSV file:
     * dataset/mydataset/!{iotanalytics:scheduleTime}/!{iotanalytics:versionId}.csv
     * If you don't use !{iotanalytics:versionId} to specify the key, you might
     * get duplicate keys. For example, you might have two dataset contents with the same
     * scheduleTime but different versionIds. This means that one
     * dataset content overwrites the other.
     */
    val key: String? = builder.key
    /**
     * The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 and Glue
     * resources.
     */
    val roleArn: String? = builder.roleArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3DestinationConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3DestinationConfiguration(")
        append("bucket=$bucket,")
        append("glueConfiguration=$glueConfiguration,")
        append("key=$key,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (glueConfiguration?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3DestinationConfiguration

        if (bucket != other.bucket) return false
        if (glueConfiguration != other.glueConfiguration) return false
        if (key != other.key) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3DestinationConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3DestinationConfiguration
        /**
         * The name of the S3 bucket to which dataset contents are delivered.
         */
        fun bucket(bucket: String): FluentBuilder
        /**
         * Configuration information for coordination with Glue, a fully managed extract, transform
         * and load (ETL) service.
         */
        fun glueConfiguration(glueConfiguration: GlueConfiguration): FluentBuilder
        /**
         * The key of the dataset contents object in an S3 bucket. Each object has a key that is a
         * unique identifier. Each object has exactly one key.
         * You can create a unique key with the following options:
         * Use !{iotanalytics:scheduleTime} to insert the time of a scheduled SQL
         * query run.
         * Use !{iotanalytics:versionId} to insert a unique hash that identifies a
         * dataset content.
         * Use !{iotanalytics:creationTime} to insert the creation time of a dataset
         * content.
         * The following example creates a unique key for a CSV file:
         * dataset/mydataset/!{iotanalytics:scheduleTime}/!{iotanalytics:versionId}.csv
         * If you don't use !{iotanalytics:versionId} to specify the key, you might
         * get duplicate keys. For example, you might have two dataset contents with the same
         * scheduleTime but different versionIds. This means that one
         * dataset content overwrites the other.
         */
        fun key(key: String): FluentBuilder
        /**
         * The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 and Glue
         * resources.
         */
        fun roleArn(roleArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the S3 bucket to which dataset contents are delivered.
         */
        var bucket: String?
        /**
         * Configuration information for coordination with Glue, a fully managed extract, transform
         * and load (ETL) service.
         */
        var glueConfiguration: GlueConfiguration?
        /**
         * The key of the dataset contents object in an S3 bucket. Each object has a key that is a
         * unique identifier. Each object has exactly one key.
         * You can create a unique key with the following options:
         * Use !{iotanalytics:scheduleTime} to insert the time of a scheduled SQL
         * query run.
         * Use !{iotanalytics:versionId} to insert a unique hash that identifies a
         * dataset content.
         * Use !{iotanalytics:creationTime} to insert the creation time of a dataset
         * content.
         * The following example creates a unique key for a CSV file:
         * dataset/mydataset/!{iotanalytics:scheduleTime}/!{iotanalytics:versionId}.csv
         * If you don't use !{iotanalytics:versionId} to specify the key, you might
         * get duplicate keys. For example, you might have two dataset contents with the same
         * scheduleTime but different versionIds. This means that one
         * dataset content overwrites the other.
         */
        var key: String?
        /**
         * The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 and Glue
         * resources.
         */
        var roleArn: String?

        fun build(): S3DestinationConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.GlueConfiguration] inside the given [block]
         */
        fun glueConfiguration(block: GlueConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.glueConfiguration = GlueConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucket: String? = null
        override var glueConfiguration: GlueConfiguration? = null
        override var key: String? = null
        override var roleArn: String? = null

        constructor(x: S3DestinationConfiguration) : this() {
            this.bucket = x.bucket
            this.glueConfiguration = x.glueConfiguration
            this.key = x.key
            this.roleArn = x.roleArn
        }

        override fun build(): S3DestinationConfiguration = S3DestinationConfiguration(this)
        override fun bucket(bucket: String): FluentBuilder = apply { this.bucket = bucket }
        override fun glueConfiguration(glueConfiguration: GlueConfiguration): FluentBuilder = apply { this.glueConfiguration = glueConfiguration }
        override fun key(key: String): FluentBuilder = apply { this.key = key }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
    }
}
