// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a pipeline.
 */
class Pipeline private constructor(builder: BuilderImpl) {
    /**
     * The activities that perform transformations on the messages.
     */
    val activities: List<PipelineActivity>? = builder.activities
    /**
     * The ARN of the pipeline.
     */
    val arn: String? = builder.arn
    /**
     * When the pipeline was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The last time the pipeline was updated.
     */
    val lastUpdateTime: Instant? = builder.lastUpdateTime
    /**
     * The name of the pipeline.
     */
    val name: String? = builder.name
    /**
     * A summary of information about the pipeline reprocessing.
     */
    val reprocessingSummaries: List<ReprocessingSummary>? = builder.reprocessingSummaries

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Pipeline = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Pipeline(")
        append("activities=$activities,")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("name=$name,")
        append("reprocessingSummaries=$reprocessingSummaries)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activities?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (reprocessingSummaries?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Pipeline

        if (activities != other.activities) return false
        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (name != other.name) return false
        if (reprocessingSummaries != other.reprocessingSummaries) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Pipeline = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Pipeline
        /**
         * The activities that perform transformations on the messages.
         */
        fun activities(activities: List<PipelineActivity>): FluentBuilder
        /**
         * The ARN of the pipeline.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * When the pipeline was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The last time the pipeline was updated.
         */
        fun lastUpdateTime(lastUpdateTime: Instant): FluentBuilder
        /**
         * The name of the pipeline.
         */
        fun name(name: String): FluentBuilder
        /**
         * A summary of information about the pipeline reprocessing.
         */
        fun reprocessingSummaries(reprocessingSummaries: List<ReprocessingSummary>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The activities that perform transformations on the messages.
         */
        var activities: List<PipelineActivity>?
        /**
         * The ARN of the pipeline.
         */
        var arn: String?
        /**
         * When the pipeline was created.
         */
        var creationTime: Instant?
        /**
         * The last time the pipeline was updated.
         */
        var lastUpdateTime: Instant?
        /**
         * The name of the pipeline.
         */
        var name: String?
        /**
         * A summary of information about the pipeline reprocessing.
         */
        var reprocessingSummaries: List<ReprocessingSummary>?

        fun build(): Pipeline
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var activities: List<PipelineActivity>? = null
        override var arn: String? = null
        override var creationTime: Instant? = null
        override var lastUpdateTime: Instant? = null
        override var name: String? = null
        override var reprocessingSummaries: List<ReprocessingSummary>? = null

        constructor(x: Pipeline) : this() {
            this.activities = x.activities
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.lastUpdateTime = x.lastUpdateTime
            this.name = x.name
            this.reprocessingSummaries = x.reprocessingSummaries
        }

        override fun build(): Pipeline = Pipeline(this)
        override fun activities(activities: List<PipelineActivity>): FluentBuilder = apply { this.activities = activities }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun lastUpdateTime(lastUpdateTime: Instant): FluentBuilder = apply { this.lastUpdateTime = lastUpdateTime }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun reprocessingSummaries(reprocessingSummaries: List<ReprocessingSummary>): FluentBuilder = apply { this.reprocessingSummaries = reprocessingSummaries }
    }
}
