// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



/**
 * An activity that computes an arithmetic expression using the message's attributes.
 */
class MathActivity private constructor(builder: BuilderImpl) {
    /**
     * The name of the attribute that contains the result of the math operation.
     */
    val attribute: String? = builder.attribute
    /**
     * An expression that uses one or more existing attributes and must return an integer
     * value.
     */
    val math: String? = builder.math
    /**
     * The name of the math activity.
     */
    val name: String? = builder.name
    /**
     * The next activity in the pipeline.
     */
    val next: String? = builder.next

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MathActivity = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MathActivity(")
        append("attribute=$attribute,")
        append("math=$math,")
        append("name=$name,")
        append("next=$next)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attribute?.hashCode() ?: 0
        result = 31 * result + (math?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (next?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MathActivity

        if (attribute != other.attribute) return false
        if (math != other.math) return false
        if (name != other.name) return false
        if (next != other.next) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MathActivity = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MathActivity
        /**
         * The name of the attribute that contains the result of the math operation.
         */
        fun attribute(attribute: String): FluentBuilder
        /**
         * An expression that uses one or more existing attributes and must return an integer
         * value.
         */
        fun math(math: String): FluentBuilder
        /**
         * The name of the math activity.
         */
        fun name(name: String): FluentBuilder
        /**
         * The next activity in the pipeline.
         */
        fun next(next: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the attribute that contains the result of the math operation.
         */
        var attribute: String?
        /**
         * An expression that uses one or more existing attributes and must return an integer
         * value.
         */
        var math: String?
        /**
         * The name of the math activity.
         */
        var name: String?
        /**
         * The next activity in the pipeline.
         */
        var next: String?

        fun build(): MathActivity
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attribute: String? = null
        override var math: String? = null
        override var name: String? = null
        override var next: String? = null

        constructor(x: MathActivity) : this() {
            this.attribute = x.attribute
            this.math = x.math
            this.name = x.name
            this.next = x.next
        }

        override fun build(): MathActivity = MathActivity(this)
        override fun attribute(attribute: String): FluentBuilder = apply { this.attribute = attribute }
        override fun math(math: String): FluentBuilder = apply { this.math = math }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun next(next: String): FluentBuilder = apply { this.next = next }
    }
}
