// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model

import aws.smithy.kotlin.runtime.time.Instant

class ListDatasetContentsRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the dataset whose contents information you want to list.
     */
    val datasetName: String? = builder.datasetName
    /**
     * The maximum number of results to return in this request.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The token for the next set of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * A filter to limit results to those dataset contents whose creation is scheduled before the
     * given time. See the field triggers.schedule in the CreateDataset
     * request. (timestamp)
     */
    val scheduledBefore: Instant? = builder.scheduledBefore
    /**
     * A filter to limit results to those dataset contents whose creation is scheduled on or
     * after the given time. See the field triggers.schedule in the
     * CreateDataset request. (timestamp)
     */
    val scheduledOnOrAfter: Instant? = builder.scheduledOnOrAfter

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListDatasetContentsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListDatasetContentsRequest(")
        append("datasetName=$datasetName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("scheduledBefore=$scheduledBefore,")
        append("scheduledOnOrAfter=$scheduledOnOrAfter)")
    }

    override fun hashCode(): kotlin.Int {
        var result = datasetName?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (scheduledBefore?.hashCode() ?: 0)
        result = 31 * result + (scheduledOnOrAfter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListDatasetContentsRequest

        if (datasetName != other.datasetName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (scheduledBefore != other.scheduledBefore) return false
        if (scheduledOnOrAfter != other.scheduledOnOrAfter) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListDatasetContentsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListDatasetContentsRequest
        /**
         * The name of the dataset whose contents information you want to list.
         */
        fun datasetName(datasetName: String): FluentBuilder
        /**
         * The maximum number of results to return in this request.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The token for the next set of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * A filter to limit results to those dataset contents whose creation is scheduled before the
         * given time. See the field triggers.schedule in the CreateDataset
         * request. (timestamp)
         */
        fun scheduledBefore(scheduledBefore: Instant): FluentBuilder
        /**
         * A filter to limit results to those dataset contents whose creation is scheduled on or
         * after the given time. See the field triggers.schedule in the
         * CreateDataset request. (timestamp)
         */
        fun scheduledOnOrAfter(scheduledOnOrAfter: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the dataset whose contents information you want to list.
         */
        var datasetName: String?
        /**
         * The maximum number of results to return in this request.
         */
        var maxResults: Int?
        /**
         * The token for the next set of results.
         */
        var nextToken: String?
        /**
         * A filter to limit results to those dataset contents whose creation is scheduled before the
         * given time. See the field triggers.schedule in the CreateDataset
         * request. (timestamp)
         */
        var scheduledBefore: Instant?
        /**
         * A filter to limit results to those dataset contents whose creation is scheduled on or
         * after the given time. See the field triggers.schedule in the
         * CreateDataset request. (timestamp)
         */
        var scheduledOnOrAfter: Instant?

        fun build(): ListDatasetContentsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var datasetName: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var scheduledBefore: Instant? = null
        override var scheduledOnOrAfter: Instant? = null

        constructor(x: ListDatasetContentsRequest) : this() {
            this.datasetName = x.datasetName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.scheduledBefore = x.scheduledBefore
            this.scheduledOnOrAfter = x.scheduledOnOrAfter
        }

        override fun build(): ListDatasetContentsRequest = ListDatasetContentsRequest(this)
        override fun datasetName(datasetName: String): FluentBuilder = apply { this.datasetName = datasetName }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun scheduledBefore(scheduledBefore: Instant): FluentBuilder = apply { this.scheduledBefore = scheduledBefore }
        override fun scheduledOnOrAfter(scheduledOnOrAfter: Instant): FluentBuilder = apply { this.scheduledOnOrAfter = scheduledOnOrAfter }
    }
}
