// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



/**
 * An activity that runs a Lambda function to modify the message.
 */
class LambdaActivity private constructor(builder: BuilderImpl) {
    /**
     * The number of messages passed to the Lambda function for processing.
     * The Lambda function must be able to process all of these messages within five minutes,
     * which is the maximum timeout duration for Lambda functions.
     */
    val batchSize: Int? = builder.batchSize
    /**
     * The name of the Lambda function that is run on the message.
     */
    val lambdaName: String? = builder.lambdaName
    /**
     * The name of the lambda activity.
     */
    val name: String? = builder.name
    /**
     * The next activity in the pipeline.
     */
    val next: String? = builder.next

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LambdaActivity = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaActivity(")
        append("batchSize=$batchSize,")
        append("lambdaName=$lambdaName,")
        append("name=$name,")
        append("next=$next)")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchSize ?: 0
        result = 31 * result + (lambdaName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (next?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LambdaActivity

        if (batchSize != other.batchSize) return false
        if (lambdaName != other.lambdaName) return false
        if (name != other.name) return false
        if (next != other.next) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LambdaActivity = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LambdaActivity
        /**
         * The number of messages passed to the Lambda function for processing.
         * The Lambda function must be able to process all of these messages within five minutes,
         * which is the maximum timeout duration for Lambda functions.
         */
        fun batchSize(batchSize: Int): FluentBuilder
        /**
         * The name of the Lambda function that is run on the message.
         */
        fun lambdaName(lambdaName: String): FluentBuilder
        /**
         * The name of the lambda activity.
         */
        fun name(name: String): FluentBuilder
        /**
         * The next activity in the pipeline.
         */
        fun next(next: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of messages passed to the Lambda function for processing.
         * The Lambda function must be able to process all of these messages within five minutes,
         * which is the maximum timeout duration for Lambda functions.
         */
        var batchSize: Int?
        /**
         * The name of the Lambda function that is run on the message.
         */
        var lambdaName: String?
        /**
         * The name of the lambda activity.
         */
        var name: String?
        /**
         * The next activity in the pipeline.
         */
        var next: String?

        fun build(): LambdaActivity
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var batchSize: Int? = null
        override var lambdaName: String? = null
        override var name: String? = null
        override var next: String? = null

        constructor(x: LambdaActivity) : this() {
            this.batchSize = x.batchSize
            this.lambdaName = x.lambdaName
            this.name = x.name
            this.next = x.next
        }

        override fun build(): LambdaActivity = LambdaActivity(this)
        override fun batchSize(batchSize: Int): FluentBuilder = apply { this.batchSize = batchSize }
        override fun lambdaName(lambdaName: String): FluentBuilder = apply { this.lambdaName = lambdaName }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun next(next: String): FluentBuilder = apply { this.next = next }
    }
}
