// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



/**
 * Configuration information for delivery of dataset contents to IoT Events.
 */
class IotEventsDestinationConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The name of the IoT Events input to which dataset contents are delivered.
     */
    val inputName: String? = builder.inputName
    /**
     * The ARN of the role that grants IoT Analytics permission to deliver dataset contents to an IoT Events
     * input.
     */
    val roleArn: String? = builder.roleArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): IotEventsDestinationConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("IotEventsDestinationConfiguration(")
        append("inputName=$inputName,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = inputName?.hashCode() ?: 0
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as IotEventsDestinationConfiguration

        if (inputName != other.inputName) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): IotEventsDestinationConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): IotEventsDestinationConfiguration
        /**
         * The name of the IoT Events input to which dataset contents are delivered.
         */
        fun inputName(inputName: String): FluentBuilder
        /**
         * The ARN of the role that grants IoT Analytics permission to deliver dataset contents to an IoT Events
         * input.
         */
        fun roleArn(roleArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the IoT Events input to which dataset contents are delivered.
         */
        var inputName: String?
        /**
         * The ARN of the role that grants IoT Analytics permission to deliver dataset contents to an IoT Events
         * input.
         */
        var roleArn: String?

        fun build(): IotEventsDestinationConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var inputName: String? = null
        override var roleArn: String? = null

        constructor(x: IotEventsDestinationConfiguration) : this() {
            this.inputName = x.inputName
            this.roleArn = x.roleArn
        }

        override fun build(): IotEventsDestinationConfiguration = IotEventsDestinationConfiguration(this)
        override fun inputName(inputName: String): FluentBuilder = apply { this.inputName = inputName }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
    }
}
