// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



/**
 * An activity that adds data from the IoT device registry to your message.
 */
class DeviceRegistryEnrichActivity private constructor(builder: BuilderImpl) {
    /**
     * The name of the attribute that is added to the message.
     */
    val attribute: String? = builder.attribute
    /**
     * The name of the deviceRegistryEnrich activity.
     */
    val name: String? = builder.name
    /**
     * The next activity in the pipeline.
     */
    val next: String? = builder.next
    /**
     * The ARN of the role that allows access to the device's registry information.
     */
    val roleArn: String? = builder.roleArn
    /**
     * The name of the IoT device whose registry information is added to the message.
     */
    val thingName: String? = builder.thingName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeviceRegistryEnrichActivity = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeviceRegistryEnrichActivity(")
        append("attribute=$attribute,")
        append("name=$name,")
        append("next=$next,")
        append("roleArn=$roleArn,")
        append("thingName=$thingName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attribute?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (next?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (thingName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeviceRegistryEnrichActivity

        if (attribute != other.attribute) return false
        if (name != other.name) return false
        if (next != other.next) return false
        if (roleArn != other.roleArn) return false
        if (thingName != other.thingName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeviceRegistryEnrichActivity = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeviceRegistryEnrichActivity
        /**
         * The name of the attribute that is added to the message.
         */
        fun attribute(attribute: String): FluentBuilder
        /**
         * The name of the deviceRegistryEnrich activity.
         */
        fun name(name: String): FluentBuilder
        /**
         * The next activity in the pipeline.
         */
        fun next(next: String): FluentBuilder
        /**
         * The ARN of the role that allows access to the device's registry information.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * The name of the IoT device whose registry information is added to the message.
         */
        fun thingName(thingName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the attribute that is added to the message.
         */
        var attribute: String?
        /**
         * The name of the deviceRegistryEnrich activity.
         */
        var name: String?
        /**
         * The next activity in the pipeline.
         */
        var next: String?
        /**
         * The ARN of the role that allows access to the device's registry information.
         */
        var roleArn: String?
        /**
         * The name of the IoT device whose registry information is added to the message.
         */
        var thingName: String?

        fun build(): DeviceRegistryEnrichActivity
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attribute: String? = null
        override var name: String? = null
        override var next: String? = null
        override var roleArn: String? = null
        override var thingName: String? = null

        constructor(x: DeviceRegistryEnrichActivity) : this() {
            this.attribute = x.attribute
            this.name = x.name
            this.next = x.next
            this.roleArn = x.roleArn
            this.thingName = x.thingName
        }

        override fun build(): DeviceRegistryEnrichActivity = DeviceRegistryEnrichActivity(this)
        override fun attribute(attribute: String): FluentBuilder = apply { this.attribute = attribute }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun next(next: String): FluentBuilder = apply { this.next = next }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun thingName(thingName: String): FluentBuilder = apply { this.thingName = thingName }
    }
}
