// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



/**
 * A structure that contains the configuration information of a delta time session
 * window.
 * <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">
 * DeltaTime
 * specifies a time interval. You can use
 * DeltaTime to create dataset contents with data that has arrived in the data
 * store since the last execution. For an example of DeltaTime, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/automate-create-dataset.html#automate-example6"> Creating
 * a SQL dataset with a delta window (CLI) in the
 * IoT Analytics User Guide.
 */
class DeltaTimeSessionWindowConfiguration private constructor(builder: BuilderImpl) {
    /**
     * A time interval. You can use timeoutInMinutes so that IoT Analytics can batch up late
     * data notifications that have been generated since the last execution. IoT Analytics sends one batch of
     * notifications to Amazon CloudWatch Events at one time.
     * For more information about how to write a timestamp expression, see <a href="https://prestodb.io/docs/0.172/functions/datetime.html">Date and Time Functions and
     * Operators, in the Presto 0.172 Documentation.
     */
    val timeoutInMinutes: Int? = builder.timeoutInMinutes

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeltaTimeSessionWindowConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeltaTimeSessionWindowConfiguration(")
        append("timeoutInMinutes=$timeoutInMinutes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = timeoutInMinutes ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeltaTimeSessionWindowConfiguration

        if (timeoutInMinutes != other.timeoutInMinutes) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeltaTimeSessionWindowConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeltaTimeSessionWindowConfiguration
        /**
         * A time interval. You can use timeoutInMinutes so that IoT Analytics can batch up late
         * data notifications that have been generated since the last execution. IoT Analytics sends one batch of
         * notifications to Amazon CloudWatch Events at one time.
         * For more information about how to write a timestamp expression, see <a href="https://prestodb.io/docs/0.172/functions/datetime.html">Date and Time Functions and
         * Operators, in the Presto 0.172 Documentation.
         */
        fun timeoutInMinutes(timeoutInMinutes: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A time interval. You can use timeoutInMinutes so that IoT Analytics can batch up late
         * data notifications that have been generated since the last execution. IoT Analytics sends one batch of
         * notifications to Amazon CloudWatch Events at one time.
         * For more information about how to write a timestamp expression, see <a href="https://prestodb.io/docs/0.172/functions/datetime.html">Date and Time Functions and
         * Operators, in the Presto 0.172 Documentation.
         */
        var timeoutInMinutes: Int?

        fun build(): DeltaTimeSessionWindowConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var timeoutInMinutes: Int? = null

        constructor(x: DeltaTimeSessionWindowConfiguration) : this() {
            this.timeoutInMinutes = x.timeoutInMinutes
        }

        override fun build(): DeltaTimeSessionWindowConfiguration = DeltaTimeSessionWindowConfiguration(this)
        override fun timeoutInMinutes(timeoutInMinutes: Int): FluentBuilder = apply { this.timeoutInMinutes = timeoutInMinutes }
    }
}
