// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of information about a data store.
 */
class DatastoreSummary private constructor(builder: BuilderImpl) {
    /**
     * When the data store was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The name of the data store.
     */
    val datastoreName: String? = builder.datastoreName
    /**
     * Contains information about the partition dimensions in a data store.
     */
    val datastorePartitions: DatastorePartitions? = builder.datastorePartitions
    /**
     * Where data in a data store is stored.
     */
    val datastoreStorage: DatastoreStorageSummary? = builder.datastoreStorage
    /**
     * The file format of the data in the data store.
     */
    val fileFormatType: FileFormatType? = builder.fileFormatType
    /**
     * The last time when a new message arrived in the data store.
     * IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the lastMessageArrivalTime value is an approximation.
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     */
    val lastMessageArrivalTime: Instant? = builder.lastMessageArrivalTime
    /**
     * The last time the data store was updated.
     */
    val lastUpdateTime: Instant? = builder.lastUpdateTime
    /**
     * The status of the data store.
     */
    val status: DatastoreStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DatastoreSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DatastoreSummary(")
        append("creationTime=$creationTime,")
        append("datastoreName=$datastoreName,")
        append("datastorePartitions=$datastorePartitions,")
        append("datastoreStorage=$datastoreStorage,")
        append("fileFormatType=$fileFormatType,")
        append("lastMessageArrivalTime=$lastMessageArrivalTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (datastoreName?.hashCode() ?: 0)
        result = 31 * result + (datastorePartitions?.hashCode() ?: 0)
        result = 31 * result + (datastoreStorage?.hashCode() ?: 0)
        result = 31 * result + (fileFormatType?.hashCode() ?: 0)
        result = 31 * result + (lastMessageArrivalTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DatastoreSummary

        if (creationTime != other.creationTime) return false
        if (datastoreName != other.datastoreName) return false
        if (datastorePartitions != other.datastorePartitions) return false
        if (datastoreStorage != other.datastoreStorage) return false
        if (fileFormatType != other.fileFormatType) return false
        if (lastMessageArrivalTime != other.lastMessageArrivalTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DatastoreSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DatastoreSummary
        /**
         * When the data store was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The name of the data store.
         */
        fun datastoreName(datastoreName: String): FluentBuilder
        /**
         * Contains information about the partition dimensions in a data store.
         */
        fun datastorePartitions(datastorePartitions: DatastorePartitions): FluentBuilder
        /**
         * Where data in a data store is stored.
         */
        fun datastoreStorage(datastoreStorage: DatastoreStorageSummary): FluentBuilder
        /**
         * The file format of the data in the data store.
         */
        fun fileFormatType(fileFormatType: FileFormatType): FluentBuilder
        /**
         * The last time when a new message arrived in the data store.
         * IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the lastMessageArrivalTime value is an approximation.
         * This feature only applies to messages that arrived in the data store after October 23, 2020.
         */
        fun lastMessageArrivalTime(lastMessageArrivalTime: Instant): FluentBuilder
        /**
         * The last time the data store was updated.
         */
        fun lastUpdateTime(lastUpdateTime: Instant): FluentBuilder
        /**
         * The status of the data store.
         */
        fun status(status: DatastoreStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * When the data store was created.
         */
        var creationTime: Instant?
        /**
         * The name of the data store.
         */
        var datastoreName: String?
        /**
         * Contains information about the partition dimensions in a data store.
         */
        var datastorePartitions: DatastorePartitions?
        /**
         * Where data in a data store is stored.
         */
        var datastoreStorage: DatastoreStorageSummary?
        /**
         * The file format of the data in the data store.
         */
        var fileFormatType: FileFormatType?
        /**
         * The last time when a new message arrived in the data store.
         * IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the lastMessageArrivalTime value is an approximation.
         * This feature only applies to messages that arrived in the data store after October 23, 2020.
         */
        var lastMessageArrivalTime: Instant?
        /**
         * The last time the data store was updated.
         */
        var lastUpdateTime: Instant?
        /**
         * The status of the data store.
         */
        var status: DatastoreStatus?

        fun build(): DatastoreSummary
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.DatastorePartitions] inside the given [block]
         */
        fun datastorePartitions(block: DatastorePartitions.DslBuilder.() -> kotlin.Unit) {
            this.datastorePartitions = DatastorePartitions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.DatastoreStorageSummary] inside the given [block]
         */
        fun datastoreStorage(block: DatastoreStorageSummary.DslBuilder.() -> kotlin.Unit) {
            this.datastoreStorage = DatastoreStorageSummary.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var creationTime: Instant? = null
        override var datastoreName: String? = null
        override var datastorePartitions: DatastorePartitions? = null
        override var datastoreStorage: DatastoreStorageSummary? = null
        override var fileFormatType: FileFormatType? = null
        override var lastMessageArrivalTime: Instant? = null
        override var lastUpdateTime: Instant? = null
        override var status: DatastoreStatus? = null

        constructor(x: DatastoreSummary) : this() {
            this.creationTime = x.creationTime
            this.datastoreName = x.datastoreName
            this.datastorePartitions = x.datastorePartitions
            this.datastoreStorage = x.datastoreStorage
            this.fileFormatType = x.fileFormatType
            this.lastMessageArrivalTime = x.lastMessageArrivalTime
            this.lastUpdateTime = x.lastUpdateTime
            this.status = x.status
        }

        override fun build(): DatastoreSummary = DatastoreSummary(this)
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun datastoreName(datastoreName: String): FluentBuilder = apply { this.datastoreName = datastoreName }
        override fun datastorePartitions(datastorePartitions: DatastorePartitions): FluentBuilder = apply { this.datastorePartitions = datastorePartitions }
        override fun datastoreStorage(datastoreStorage: DatastoreStorageSummary): FluentBuilder = apply { this.datastoreStorage = datastoreStorage }
        override fun fileFormatType(fileFormatType: FileFormatType): FluentBuilder = apply { this.fileFormatType = fileFormatType }
        override fun lastMessageArrivalTime(lastMessageArrivalTime: Instant): FluentBuilder = apply { this.lastMessageArrivalTime = lastMessageArrivalTime }
        override fun lastUpdateTime(lastUpdateTime: Instant): FluentBuilder = apply { this.lastUpdateTime = lastUpdateTime }
        override fun status(status: DatastoreStatus): FluentBuilder = apply { this.status = status }
    }
}
