// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a data store.
 */
class Datastore private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the data store.
     */
    val arn: String? = builder.arn
    /**
     * When the data store was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * Contains information about the partition dimensions in a data store.
     */
    val datastorePartitions: DatastorePartitions? = builder.datastorePartitions
    /**
     * Contains the configuration information of file formats.  IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet.
     * The default file format is JSON. You can specify only one format.
     * You can't change the file format after you create the data store.
     */
    val fileFormatConfiguration: FileFormatConfiguration? = builder.fileFormatConfiguration
    /**
     * The last time when a new message arrived in the data store.
     * IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the lastMessageArrivalTime value is an approximation.
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     */
    val lastMessageArrivalTime: Instant? = builder.lastMessageArrivalTime
    /**
     * The last time the data store was updated.
     */
    val lastUpdateTime: Instant? = builder.lastUpdateTime
    /**
     * The name of the data store.
     */
    val name: String? = builder.name
    /**
     * How long, in days, message data is kept for the data store. When
     * customerManagedS3 storage is selected, this parameter is ignored.
     */
    val retentionPeriod: RetentionPeriod? = builder.retentionPeriod
    /**
     * The status of a data store:
     * CREATING
     * The data store is being created.
     * ACTIVE
     * The data store has been created and can be used.
     * DELETING
     * The data store is being deleted.
     */
    val status: DatastoreStatus? = builder.status
    /**
     * Where data in a data store is stored.. You can choose serviceManagedS3 storage, customerManagedS3 storage, or iotSiteWiseMultiLayerStorage storage. The default is serviceManagedS3. You can't change the choice of Amazon S3 storage after your data store is created.
     */
    val storage: DatastoreStorage? = builder.storage

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Datastore = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Datastore(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("datastorePartitions=$datastorePartitions,")
        append("fileFormatConfiguration=$fileFormatConfiguration,")
        append("lastMessageArrivalTime=$lastMessageArrivalTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("name=$name,")
        append("retentionPeriod=$retentionPeriod,")
        append("status=$status,")
        append("storage=$storage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (datastorePartitions?.hashCode() ?: 0)
        result = 31 * result + (fileFormatConfiguration?.hashCode() ?: 0)
        result = 31 * result + (lastMessageArrivalTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Datastore

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (datastorePartitions != other.datastorePartitions) return false
        if (fileFormatConfiguration != other.fileFormatConfiguration) return false
        if (lastMessageArrivalTime != other.lastMessageArrivalTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (name != other.name) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (status != other.status) return false
        if (storage != other.storage) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Datastore = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Datastore
        /**
         * The ARN of the data store.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * When the data store was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * Contains information about the partition dimensions in a data store.
         */
        fun datastorePartitions(datastorePartitions: DatastorePartitions): FluentBuilder
        /**
         * Contains the configuration information of file formats.  IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet.
         * The default file format is JSON. You can specify only one format.
         * You can't change the file format after you create the data store.
         */
        fun fileFormatConfiguration(fileFormatConfiguration: FileFormatConfiguration): FluentBuilder
        /**
         * The last time when a new message arrived in the data store.
         * IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the lastMessageArrivalTime value is an approximation.
         * This feature only applies to messages that arrived in the data store after October 23, 2020.
         */
        fun lastMessageArrivalTime(lastMessageArrivalTime: Instant): FluentBuilder
        /**
         * The last time the data store was updated.
         */
        fun lastUpdateTime(lastUpdateTime: Instant): FluentBuilder
        /**
         * The name of the data store.
         */
        fun name(name: String): FluentBuilder
        /**
         * How long, in days, message data is kept for the data store. When
         * customerManagedS3 storage is selected, this parameter is ignored.
         */
        fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder
        /**
         * The status of a data store:
         * CREATING
         * The data store is being created.
         * ACTIVE
         * The data store has been created and can be used.
         * DELETING
         * The data store is being deleted.
         */
        fun status(status: DatastoreStatus): FluentBuilder
        /**
         * Where data in a data store is stored.. You can choose serviceManagedS3 storage, customerManagedS3 storage, or iotSiteWiseMultiLayerStorage storage. The default is serviceManagedS3. You can't change the choice of Amazon S3 storage after your data store is created.
         */
        fun storage(storage: DatastoreStorage): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the data store.
         */
        var arn: String?
        /**
         * When the data store was created.
         */
        var creationTime: Instant?
        /**
         * Contains information about the partition dimensions in a data store.
         */
        var datastorePartitions: DatastorePartitions?
        /**
         * Contains the configuration information of file formats.  IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet.
         * The default file format is JSON. You can specify only one format.
         * You can't change the file format after you create the data store.
         */
        var fileFormatConfiguration: FileFormatConfiguration?
        /**
         * The last time when a new message arrived in the data store.
         * IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the lastMessageArrivalTime value is an approximation.
         * This feature only applies to messages that arrived in the data store after October 23, 2020.
         */
        var lastMessageArrivalTime: Instant?
        /**
         * The last time the data store was updated.
         */
        var lastUpdateTime: Instant?
        /**
         * The name of the data store.
         */
        var name: String?
        /**
         * How long, in days, message data is kept for the data store. When
         * customerManagedS3 storage is selected, this parameter is ignored.
         */
        var retentionPeriod: RetentionPeriod?
        /**
         * The status of a data store:
         * CREATING
         * The data store is being created.
         * ACTIVE
         * The data store has been created and can be used.
         * DELETING
         * The data store is being deleted.
         */
        var status: DatastoreStatus?
        /**
         * Where data in a data store is stored.. You can choose serviceManagedS3 storage, customerManagedS3 storage, or iotSiteWiseMultiLayerStorage storage. The default is serviceManagedS3. You can't change the choice of Amazon S3 storage after your data store is created.
         */
        var storage: DatastoreStorage?

        fun build(): Datastore
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.DatastorePartitions] inside the given [block]
         */
        fun datastorePartitions(block: DatastorePartitions.DslBuilder.() -> kotlin.Unit) {
            this.datastorePartitions = DatastorePartitions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.FileFormatConfiguration] inside the given [block]
         */
        fun fileFormatConfiguration(block: FileFormatConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.fileFormatConfiguration = FileFormatConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod] inside the given [block]
         */
        fun retentionPeriod(block: RetentionPeriod.DslBuilder.() -> kotlin.Unit) {
            this.retentionPeriod = RetentionPeriod.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var creationTime: Instant? = null
        override var datastorePartitions: DatastorePartitions? = null
        override var fileFormatConfiguration: FileFormatConfiguration? = null
        override var lastMessageArrivalTime: Instant? = null
        override var lastUpdateTime: Instant? = null
        override var name: String? = null
        override var retentionPeriod: RetentionPeriod? = null
        override var status: DatastoreStatus? = null
        override var storage: DatastoreStorage? = null

        constructor(x: Datastore) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.datastorePartitions = x.datastorePartitions
            this.fileFormatConfiguration = x.fileFormatConfiguration
            this.lastMessageArrivalTime = x.lastMessageArrivalTime
            this.lastUpdateTime = x.lastUpdateTime
            this.name = x.name
            this.retentionPeriod = x.retentionPeriod
            this.status = x.status
            this.storage = x.storage
        }

        override fun build(): Datastore = Datastore(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun datastorePartitions(datastorePartitions: DatastorePartitions): FluentBuilder = apply { this.datastorePartitions = datastorePartitions }
        override fun fileFormatConfiguration(fileFormatConfiguration: FileFormatConfiguration): FluentBuilder = apply { this.fileFormatConfiguration = fileFormatConfiguration }
        override fun lastMessageArrivalTime(lastMessageArrivalTime: Instant): FluentBuilder = apply { this.lastMessageArrivalTime = lastMessageArrivalTime }
        override fun lastUpdateTime(lastUpdateTime: Instant): FluentBuilder = apply { this.lastUpdateTime = lastUpdateTime }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder = apply { this.retentionPeriod = retentionPeriod }
        override fun status(status: DatastoreStatus): FluentBuilder = apply { this.status = status }
        override fun storage(storage: DatastoreStorage): FluentBuilder = apply { this.storage = storage }
    }
}
