// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



/**
 * A DatasetAction object that specifies how dataset contents are automatically
 * created.
 */
class DatasetAction private constructor(builder: BuilderImpl) {
    /**
     * The name of the dataset action by which dataset contents are automatically created.
     */
    val actionName: String? = builder.actionName
    /**
     * Information that allows the system to run a containerized application to create the
     * dataset contents. The application must be in a Docker container along with any required
     * support libraries.
     */
    val containerAction: ContainerDatasetAction? = builder.containerAction
    /**
     * An SqlQueryDatasetAction object that uses an SQL query to automatically
     * create dataset contents.
     */
    val queryAction: SqlQueryDatasetAction? = builder.queryAction

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DatasetAction = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetAction(")
        append("actionName=$actionName,")
        append("containerAction=$containerAction,")
        append("queryAction=$queryAction)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionName?.hashCode() ?: 0
        result = 31 * result + (containerAction?.hashCode() ?: 0)
        result = 31 * result + (queryAction?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DatasetAction

        if (actionName != other.actionName) return false
        if (containerAction != other.containerAction) return false
        if (queryAction != other.queryAction) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DatasetAction = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DatasetAction
        /**
         * The name of the dataset action by which dataset contents are automatically created.
         */
        fun actionName(actionName: String): FluentBuilder
        /**
         * Information that allows the system to run a containerized application to create the
         * dataset contents. The application must be in a Docker container along with any required
         * support libraries.
         */
        fun containerAction(containerAction: ContainerDatasetAction): FluentBuilder
        /**
         * An SqlQueryDatasetAction object that uses an SQL query to automatically
         * create dataset contents.
         */
        fun queryAction(queryAction: SqlQueryDatasetAction): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the dataset action by which dataset contents are automatically created.
         */
        var actionName: String?
        /**
         * Information that allows the system to run a containerized application to create the
         * dataset contents. The application must be in a Docker container along with any required
         * support libraries.
         */
        var containerAction: ContainerDatasetAction?
        /**
         * An SqlQueryDatasetAction object that uses an SQL query to automatically
         * create dataset contents.
         */
        var queryAction: SqlQueryDatasetAction?

        fun build(): DatasetAction
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.ContainerDatasetAction] inside the given [block]
         */
        fun containerAction(block: ContainerDatasetAction.DslBuilder.() -> kotlin.Unit) {
            this.containerAction = ContainerDatasetAction.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.SqlQueryDatasetAction] inside the given [block]
         */
        fun queryAction(block: SqlQueryDatasetAction.DslBuilder.() -> kotlin.Unit) {
            this.queryAction = SqlQueryDatasetAction.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var actionName: String? = null
        override var containerAction: ContainerDatasetAction? = null
        override var queryAction: SqlQueryDatasetAction? = null

        constructor(x: DatasetAction) : this() {
            this.actionName = x.actionName
            this.containerAction = x.containerAction
            this.queryAction = x.queryAction
        }

        override fun build(): DatasetAction = DatasetAction(this)
        override fun actionName(actionName: String): FluentBuilder = apply { this.actionName = actionName }
        override fun containerAction(containerAction: ContainerDatasetAction): FluentBuilder = apply { this.containerAction = containerAction }
        override fun queryAction(queryAction: SqlQueryDatasetAction): FluentBuilder = apply { this.queryAction = queryAction }
    }
}
