// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a dataset.
 */
class Dataset private constructor(builder: BuilderImpl) {
    /**
     * The DatasetAction objects that automatically create the dataset
     * contents.
     */
    val actions: List<DatasetAction>? = builder.actions
    /**
     * The ARN of the dataset.
     */
    val arn: String? = builder.arn
    /**
     * When dataset contents are created they are delivered to destinations specified
     * here.
     */
    val contentDeliveryRules: List<DatasetContentDeliveryRule>? = builder.contentDeliveryRules
    /**
     * When the dataset was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The last time the dataset was updated.
     */
    val lastUpdateTime: Instant? = builder.lastUpdateTime
    /**
     * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify lateDataRules, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer filter.
     */
    val lateDataRules: List<LateDataRule>? = builder.lateDataRules
    /**
     * The name of the dataset.
     */
    val name: String? = builder.name
    /**
     * Optional. How long, in days, message data is kept for the dataset.
     */
    val retentionPeriod: RetentionPeriod? = builder.retentionPeriod
    /**
     * The status of the dataset.
     */
    val status: DatasetStatus? = builder.status
    /**
     * The DatasetTrigger objects that specify when the dataset is automatically
     * updated.
     */
    val triggers: List<DatasetTrigger>? = builder.triggers
    /**
     * Optional. How many versions of dataset contents are kept. If not specified or set to null,
     * only the latest version plus the latest succeeded version (if they are different) are kept for
     * the time period specified by the retentionPeriod parameter. For more information,
     * see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">
     * Keeping Multiple Versions of IoT Analytics datasets in the
     * IoT Analytics User Guide.
     */
    val versioningConfiguration: VersioningConfiguration? = builder.versioningConfiguration

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Dataset = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Dataset(")
        append("actions=$actions,")
        append("arn=$arn,")
        append("contentDeliveryRules=$contentDeliveryRules,")
        append("creationTime=$creationTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("lateDataRules=$lateDataRules,")
        append("name=$name,")
        append("retentionPeriod=$retentionPeriod,")
        append("status=$status,")
        append("triggers=$triggers,")
        append("versioningConfiguration=$versioningConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (contentDeliveryRules?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (lateDataRules?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (triggers?.hashCode() ?: 0)
        result = 31 * result + (versioningConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Dataset

        if (actions != other.actions) return false
        if (arn != other.arn) return false
        if (contentDeliveryRules != other.contentDeliveryRules) return false
        if (creationTime != other.creationTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (lateDataRules != other.lateDataRules) return false
        if (name != other.name) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (status != other.status) return false
        if (triggers != other.triggers) return false
        if (versioningConfiguration != other.versioningConfiguration) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Dataset = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Dataset
        /**
         * The DatasetAction objects that automatically create the dataset
         * contents.
         */
        fun actions(actions: List<DatasetAction>): FluentBuilder
        /**
         * The ARN of the dataset.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * When dataset contents are created they are delivered to destinations specified
         * here.
         */
        fun contentDeliveryRules(contentDeliveryRules: List<DatasetContentDeliveryRule>): FluentBuilder
        /**
         * When the dataset was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The last time the dataset was updated.
         */
        fun lastUpdateTime(lastUpdateTime: Instant): FluentBuilder
        /**
         * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify lateDataRules, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer filter.
         */
        fun lateDataRules(lateDataRules: List<LateDataRule>): FluentBuilder
        /**
         * The name of the dataset.
         */
        fun name(name: String): FluentBuilder
        /**
         * Optional. How long, in days, message data is kept for the dataset.
         */
        fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder
        /**
         * The status of the dataset.
         */
        fun status(status: DatasetStatus): FluentBuilder
        /**
         * The DatasetTrigger objects that specify when the dataset is automatically
         * updated.
         */
        fun triggers(triggers: List<DatasetTrigger>): FluentBuilder
        /**
         * Optional. How many versions of dataset contents are kept. If not specified or set to null,
         * only the latest version plus the latest succeeded version (if they are different) are kept for
         * the time period specified by the retentionPeriod parameter. For more information,
         * see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">
         * Keeping Multiple Versions of IoT Analytics datasets in the
         * IoT Analytics User Guide.
         */
        fun versioningConfiguration(versioningConfiguration: VersioningConfiguration): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The DatasetAction objects that automatically create the dataset
         * contents.
         */
        var actions: List<DatasetAction>?
        /**
         * The ARN of the dataset.
         */
        var arn: String?
        /**
         * When dataset contents are created they are delivered to destinations specified
         * here.
         */
        var contentDeliveryRules: List<DatasetContentDeliveryRule>?
        /**
         * When the dataset was created.
         */
        var creationTime: Instant?
        /**
         * The last time the dataset was updated.
         */
        var lastUpdateTime: Instant?
        /**
         * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify lateDataRules, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer filter.
         */
        var lateDataRules: List<LateDataRule>?
        /**
         * The name of the dataset.
         */
        var name: String?
        /**
         * Optional. How long, in days, message data is kept for the dataset.
         */
        var retentionPeriod: RetentionPeriod?
        /**
         * The status of the dataset.
         */
        var status: DatasetStatus?
        /**
         * The DatasetTrigger objects that specify when the dataset is automatically
         * updated.
         */
        var triggers: List<DatasetTrigger>?
        /**
         * Optional. How many versions of dataset contents are kept. If not specified or set to null,
         * only the latest version plus the latest succeeded version (if they are different) are kept for
         * the time period specified by the retentionPeriod parameter. For more information,
         * see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">
         * Keeping Multiple Versions of IoT Analytics datasets in the
         * IoT Analytics User Guide.
         */
        var versioningConfiguration: VersioningConfiguration?

        fun build(): Dataset
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod] inside the given [block]
         */
        fun retentionPeriod(block: RetentionPeriod.DslBuilder.() -> kotlin.Unit) {
            this.retentionPeriod = RetentionPeriod.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration] inside the given [block]
         */
        fun versioningConfiguration(block: VersioningConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.versioningConfiguration = VersioningConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var actions: List<DatasetAction>? = null
        override var arn: String? = null
        override var contentDeliveryRules: List<DatasetContentDeliveryRule>? = null
        override var creationTime: Instant? = null
        override var lastUpdateTime: Instant? = null
        override var lateDataRules: List<LateDataRule>? = null
        override var name: String? = null
        override var retentionPeriod: RetentionPeriod? = null
        override var status: DatasetStatus? = null
        override var triggers: List<DatasetTrigger>? = null
        override var versioningConfiguration: VersioningConfiguration? = null

        constructor(x: Dataset) : this() {
            this.actions = x.actions
            this.arn = x.arn
            this.contentDeliveryRules = x.contentDeliveryRules
            this.creationTime = x.creationTime
            this.lastUpdateTime = x.lastUpdateTime
            this.lateDataRules = x.lateDataRules
            this.name = x.name
            this.retentionPeriod = x.retentionPeriod
            this.status = x.status
            this.triggers = x.triggers
            this.versioningConfiguration = x.versioningConfiguration
        }

        override fun build(): Dataset = Dataset(this)
        override fun actions(actions: List<DatasetAction>): FluentBuilder = apply { this.actions = actions }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun contentDeliveryRules(contentDeliveryRules: List<DatasetContentDeliveryRule>): FluentBuilder = apply { this.contentDeliveryRules = contentDeliveryRules }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun lastUpdateTime(lastUpdateTime: Instant): FluentBuilder = apply { this.lastUpdateTime = lastUpdateTime }
        override fun lateDataRules(lateDataRules: List<LateDataRule>): FluentBuilder = apply { this.lateDataRules = lateDataRules }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder = apply { this.retentionPeriod = retentionPeriod }
        override fun status(status: DatasetStatus): FluentBuilder = apply { this.status = status }
        override fun triggers(triggers: List<DatasetTrigger>): FluentBuilder = apply { this.triggers = triggers }
        override fun versioningConfiguration(versioningConfiguration: VersioningConfiguration): FluentBuilder = apply { this.versioningConfiguration = versioningConfiguration }
    }
}
