// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



/**
 * Used to store channel data in an S3 bucket that you manage. If customer-managed storage is
 * selected, the retentionPeriod parameter is ignored. You can't change the choice
 * of S3 storage after the data store is created.
 */
class CustomerManagedChannelS3Storage private constructor(builder: BuilderImpl) {
    /**
     * The name of the S3 bucket in which channel data is stored.
     */
    val bucket: String? = builder.bucket
    /**
     * (Optional) The prefix used to create the keys of the channel data objects. Each object in
     * an S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket
     * has exactly one key. The prefix must end with a forward slash (/).
     */
    val keyPrefix: String? = builder.keyPrefix
    /**
     * The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3
     * resources.
     */
    val roleArn: String? = builder.roleArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CustomerManagedChannelS3Storage = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CustomerManagedChannelS3Storage(")
        append("bucket=$bucket,")
        append("keyPrefix=$keyPrefix,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (keyPrefix?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CustomerManagedChannelS3Storage

        if (bucket != other.bucket) return false
        if (keyPrefix != other.keyPrefix) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CustomerManagedChannelS3Storage = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CustomerManagedChannelS3Storage
        /**
         * The name of the S3 bucket in which channel data is stored.
         */
        fun bucket(bucket: String): FluentBuilder
        /**
         * (Optional) The prefix used to create the keys of the channel data objects. Each object in
         * an S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket
         * has exactly one key. The prefix must end with a forward slash (/).
         */
        fun keyPrefix(keyPrefix: String): FluentBuilder
        /**
         * The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3
         * resources.
         */
        fun roleArn(roleArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the S3 bucket in which channel data is stored.
         */
        var bucket: String?
        /**
         * (Optional) The prefix used to create the keys of the channel data objects. Each object in
         * an S3 bucket has a key that is its unique identifier in the bucket. Each object in a bucket
         * has exactly one key. The prefix must end with a forward slash (/).
         */
        var keyPrefix: String?
        /**
         * The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3
         * resources.
         */
        var roleArn: String?

        fun build(): CustomerManagedChannelS3Storage
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucket: String? = null
        override var keyPrefix: String? = null
        override var roleArn: String? = null

        constructor(x: CustomerManagedChannelS3Storage) : this() {
            this.bucket = x.bucket
            this.keyPrefix = x.keyPrefix
            this.roleArn = x.roleArn
        }

        override fun build(): CustomerManagedChannelS3Storage = CustomerManagedChannelS3Storage(this)
        override fun bucket(bucket: String): FluentBuilder = apply { this.bucket = bucket }
        override fun keyPrefix(keyPrefix: String): FluentBuilder = apply { this.keyPrefix = keyPrefix }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
    }
}
