// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



class CreateDatastoreRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the data store.
     */
    val datastoreName: String? = builder.datastoreName
    /**
     * Contains information about the partition dimensions in a data store.
     */
    val datastorePartitions: DatastorePartitions? = builder.datastorePartitions
    /**
     * Where data in a data store is stored.. You can choose serviceManagedS3 storage, customerManagedS3 storage, or iotSiteWiseMultiLayerStorage storage. The default is serviceManagedS3. You can't change the choice of Amazon S3 storage after your data store is created.
     */
    val datastoreStorage: DatastoreStorage? = builder.datastoreStorage
    /**
     * Contains the configuration information of file formats.  IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet.
     * The default file format is JSON. You can specify only one format.
     * You can't change the file format after you create the data store.
     */
    val fileFormatConfiguration: FileFormatConfiguration? = builder.fileFormatConfiguration
    /**
     * How long, in days, message data is kept for the data store. When
     * customerManagedS3 storage is selected, this parameter is ignored.
     */
    val retentionPeriod: RetentionPeriod? = builder.retentionPeriod
    /**
     * Metadata which can be used to manage the data store.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateDatastoreRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDatastoreRequest(")
        append("datastoreName=$datastoreName,")
        append("datastorePartitions=$datastorePartitions,")
        append("datastoreStorage=$datastoreStorage,")
        append("fileFormatConfiguration=$fileFormatConfiguration,")
        append("retentionPeriod=$retentionPeriod,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = datastoreName?.hashCode() ?: 0
        result = 31 * result + (datastorePartitions?.hashCode() ?: 0)
        result = 31 * result + (datastoreStorage?.hashCode() ?: 0)
        result = 31 * result + (fileFormatConfiguration?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateDatastoreRequest

        if (datastoreName != other.datastoreName) return false
        if (datastorePartitions != other.datastorePartitions) return false
        if (datastoreStorage != other.datastoreStorage) return false
        if (fileFormatConfiguration != other.fileFormatConfiguration) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateDatastoreRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateDatastoreRequest
        /**
         * The name of the data store.
         */
        fun datastoreName(datastoreName: String): FluentBuilder
        /**
         * Contains information about the partition dimensions in a data store.
         */
        fun datastorePartitions(datastorePartitions: DatastorePartitions): FluentBuilder
        /**
         * Where data in a data store is stored.. You can choose serviceManagedS3 storage, customerManagedS3 storage, or iotSiteWiseMultiLayerStorage storage. The default is serviceManagedS3. You can't change the choice of Amazon S3 storage after your data store is created.
         */
        fun datastoreStorage(datastoreStorage: DatastoreStorage): FluentBuilder
        /**
         * Contains the configuration information of file formats.  IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet.
         * The default file format is JSON. You can specify only one format.
         * You can't change the file format after you create the data store.
         */
        fun fileFormatConfiguration(fileFormatConfiguration: FileFormatConfiguration): FluentBuilder
        /**
         * How long, in days, message data is kept for the data store. When
         * customerManagedS3 storage is selected, this parameter is ignored.
         */
        fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder
        /**
         * Metadata which can be used to manage the data store.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the data store.
         */
        var datastoreName: String?
        /**
         * Contains information about the partition dimensions in a data store.
         */
        var datastorePartitions: DatastorePartitions?
        /**
         * Where data in a data store is stored.. You can choose serviceManagedS3 storage, customerManagedS3 storage, or iotSiteWiseMultiLayerStorage storage. The default is serviceManagedS3. You can't change the choice of Amazon S3 storage after your data store is created.
         */
        var datastoreStorage: DatastoreStorage?
        /**
         * Contains the configuration information of file formats.  IoT Analytics data stores support JSON and <a href="https://parquet.apache.org/">Parquet.
         * The default file format is JSON. You can specify only one format.
         * You can't change the file format after you create the data store.
         */
        var fileFormatConfiguration: FileFormatConfiguration?
        /**
         * How long, in days, message data is kept for the data store. When
         * customerManagedS3 storage is selected, this parameter is ignored.
         */
        var retentionPeriod: RetentionPeriod?
        /**
         * Metadata which can be used to manage the data store.
         */
        var tags: List<Tag>?

        fun build(): CreateDatastoreRequest
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.DatastorePartitions] inside the given [block]
         */
        fun datastorePartitions(block: DatastorePartitions.DslBuilder.() -> kotlin.Unit) {
            this.datastorePartitions = DatastorePartitions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.FileFormatConfiguration] inside the given [block]
         */
        fun fileFormatConfiguration(block: FileFormatConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.fileFormatConfiguration = FileFormatConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod] inside the given [block]
         */
        fun retentionPeriod(block: RetentionPeriod.DslBuilder.() -> kotlin.Unit) {
            this.retentionPeriod = RetentionPeriod.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var datastoreName: String? = null
        override var datastorePartitions: DatastorePartitions? = null
        override var datastoreStorage: DatastoreStorage? = null
        override var fileFormatConfiguration: FileFormatConfiguration? = null
        override var retentionPeriod: RetentionPeriod? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateDatastoreRequest) : this() {
            this.datastoreName = x.datastoreName
            this.datastorePartitions = x.datastorePartitions
            this.datastoreStorage = x.datastoreStorage
            this.fileFormatConfiguration = x.fileFormatConfiguration
            this.retentionPeriod = x.retentionPeriod
            this.tags = x.tags
        }

        override fun build(): CreateDatastoreRequest = CreateDatastoreRequest(this)
        override fun datastoreName(datastoreName: String): FluentBuilder = apply { this.datastoreName = datastoreName }
        override fun datastorePartitions(datastorePartitions: DatastorePartitions): FluentBuilder = apply { this.datastorePartitions = datastorePartitions }
        override fun datastoreStorage(datastoreStorage: DatastoreStorage): FluentBuilder = apply { this.datastoreStorage = datastoreStorage }
        override fun fileFormatConfiguration(fileFormatConfiguration: FileFormatConfiguration): FluentBuilder = apply { this.fileFormatConfiguration = fileFormatConfiguration }
        override fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder = apply { this.retentionPeriod = retentionPeriod }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
