// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



class CreateDatasetRequest private constructor(builder: BuilderImpl) {
    /**
     * A list of actions that create the dataset contents.
     */
    val actions: List<DatasetAction>? = builder.actions
    /**
     * When dataset contents are created, they are delivered to destinations specified
     * here.
     */
    val contentDeliveryRules: List<DatasetContentDeliveryRule>? = builder.contentDeliveryRules
    /**
     * The name of the dataset.
     */
    val datasetName: String? = builder.datasetName
    /**
     * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify lateDataRules, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer filter.
     */
    val lateDataRules: List<LateDataRule>? = builder.lateDataRules
    /**
     * Optional. How long, in days, versions of dataset contents are kept for the dataset. If not
     * specified or set to null, versions of dataset contents are retained for at most
     * 90 days. The number of versions of dataset contents retained is determined by the
     * versioningConfiguration parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">
     * Keeping Multiple Versions of IoT Analytics datasets in the
     * IoT Analytics User Guide.
     */
    val retentionPeriod: RetentionPeriod? = builder.retentionPeriod
    /**
     * Metadata which can be used to manage the dataset.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A list of triggers. A trigger causes dataset contents to be populated at a specified time
     * interval or when another dataset's contents are created. The list of triggers can be empty or
     * contain up to five DataSetTrigger objects.
     */
    val triggers: List<DatasetTrigger>? = builder.triggers
    /**
     * Optional. How many versions of dataset contents are kept. If not specified or set to null,
     * only the latest version plus the latest succeeded version (if they are different) are kept for
     * the time period specified by the retentionPeriod parameter. For more information,
     * see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of IoT Analytics datasets in the
     * IoT Analytics User Guide.
     */
    val versioningConfiguration: VersioningConfiguration? = builder.versioningConfiguration

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateDatasetRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDatasetRequest(")
        append("actions=$actions,")
        append("contentDeliveryRules=$contentDeliveryRules,")
        append("datasetName=$datasetName,")
        append("lateDataRules=$lateDataRules,")
        append("retentionPeriod=$retentionPeriod,")
        append("tags=$tags,")
        append("triggers=$triggers,")
        append("versioningConfiguration=$versioningConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (contentDeliveryRules?.hashCode() ?: 0)
        result = 31 * result + (datasetName?.hashCode() ?: 0)
        result = 31 * result + (lateDataRules?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (triggers?.hashCode() ?: 0)
        result = 31 * result + (versioningConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateDatasetRequest

        if (actions != other.actions) return false
        if (contentDeliveryRules != other.contentDeliveryRules) return false
        if (datasetName != other.datasetName) return false
        if (lateDataRules != other.lateDataRules) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (tags != other.tags) return false
        if (triggers != other.triggers) return false
        if (versioningConfiguration != other.versioningConfiguration) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateDatasetRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateDatasetRequest
        /**
         * A list of actions that create the dataset contents.
         */
        fun actions(actions: List<DatasetAction>): FluentBuilder
        /**
         * When dataset contents are created, they are delivered to destinations specified
         * here.
         */
        fun contentDeliveryRules(contentDeliveryRules: List<DatasetContentDeliveryRule>): FluentBuilder
        /**
         * The name of the dataset.
         */
        fun datasetName(datasetName: String): FluentBuilder
        /**
         * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify lateDataRules, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer filter.
         */
        fun lateDataRules(lateDataRules: List<LateDataRule>): FluentBuilder
        /**
         * Optional. How long, in days, versions of dataset contents are kept for the dataset. If not
         * specified or set to null, versions of dataset contents are retained for at most
         * 90 days. The number of versions of dataset contents retained is determined by the
         * versioningConfiguration parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">
         * Keeping Multiple Versions of IoT Analytics datasets in the
         * IoT Analytics User Guide.
         */
        fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder
        /**
         * Metadata which can be used to manage the dataset.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * A list of triggers. A trigger causes dataset contents to be populated at a specified time
         * interval or when another dataset's contents are created. The list of triggers can be empty or
         * contain up to five DataSetTrigger objects.
         */
        fun triggers(triggers: List<DatasetTrigger>): FluentBuilder
        /**
         * Optional. How many versions of dataset contents are kept. If not specified or set to null,
         * only the latest version plus the latest succeeded version (if they are different) are kept for
         * the time period specified by the retentionPeriod parameter. For more information,
         * see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of IoT Analytics datasets in the
         * IoT Analytics User Guide.
         */
        fun versioningConfiguration(versioningConfiguration: VersioningConfiguration): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of actions that create the dataset contents.
         */
        var actions: List<DatasetAction>?
        /**
         * When dataset contents are created, they are delivered to destinations specified
         * here.
         */
        var contentDeliveryRules: List<DatasetContentDeliveryRule>?
        /**
         * The name of the dataset.
         */
        var datasetName: String?
        /**
         * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify lateDataRules, the dataset must use a <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer filter.
         */
        var lateDataRules: List<LateDataRule>?
        /**
         * Optional. How long, in days, versions of dataset contents are kept for the dataset. If not
         * specified or set to null, versions of dataset contents are retained for at most
         * 90 days. The number of versions of dataset contents retained is determined by the
         * versioningConfiguration parameter. For more information, see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">
         * Keeping Multiple Versions of IoT Analytics datasets in the
         * IoT Analytics User Guide.
         */
        var retentionPeriod: RetentionPeriod?
        /**
         * Metadata which can be used to manage the dataset.
         */
        var tags: List<Tag>?
        /**
         * A list of triggers. A trigger causes dataset contents to be populated at a specified time
         * interval or when another dataset's contents are created. The list of triggers can be empty or
         * contain up to five DataSetTrigger objects.
         */
        var triggers: List<DatasetTrigger>?
        /**
         * Optional. How many versions of dataset contents are kept. If not specified or set to null,
         * only the latest version plus the latest succeeded version (if they are different) are kept for
         * the time period specified by the retentionPeriod parameter. For more information,
         * see <a href="https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions">Keeping Multiple Versions of IoT Analytics datasets in the
         * IoT Analytics User Guide.
         */
        var versioningConfiguration: VersioningConfiguration?

        fun build(): CreateDatasetRequest
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod] inside the given [block]
         */
        fun retentionPeriod(block: RetentionPeriod.DslBuilder.() -> kotlin.Unit) {
            this.retentionPeriod = RetentionPeriod.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration] inside the given [block]
         */
        fun versioningConfiguration(block: VersioningConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.versioningConfiguration = VersioningConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var actions: List<DatasetAction>? = null
        override var contentDeliveryRules: List<DatasetContentDeliveryRule>? = null
        override var datasetName: String? = null
        override var lateDataRules: List<LateDataRule>? = null
        override var retentionPeriod: RetentionPeriod? = null
        override var tags: List<Tag>? = null
        override var triggers: List<DatasetTrigger>? = null
        override var versioningConfiguration: VersioningConfiguration? = null

        constructor(x: CreateDatasetRequest) : this() {
            this.actions = x.actions
            this.contentDeliveryRules = x.contentDeliveryRules
            this.datasetName = x.datasetName
            this.lateDataRules = x.lateDataRules
            this.retentionPeriod = x.retentionPeriod
            this.tags = x.tags
            this.triggers = x.triggers
            this.versioningConfiguration = x.versioningConfiguration
        }

        override fun build(): CreateDatasetRequest = CreateDatasetRequest(this)
        override fun actions(actions: List<DatasetAction>): FluentBuilder = apply { this.actions = actions }
        override fun contentDeliveryRules(contentDeliveryRules: List<DatasetContentDeliveryRule>): FluentBuilder = apply { this.contentDeliveryRules = contentDeliveryRules }
        override fun datasetName(datasetName: String): FluentBuilder = apply { this.datasetName = datasetName }
        override fun lateDataRules(lateDataRules: List<LateDataRule>): FluentBuilder = apply { this.lateDataRules = lateDataRules }
        override fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder = apply { this.retentionPeriod = retentionPeriod }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun triggers(triggers: List<DatasetTrigger>): FluentBuilder = apply { this.triggers = triggers }
        override fun versioningConfiguration(versioningConfiguration: VersioningConfiguration): FluentBuilder = apply { this.versioningConfiguration = versioningConfiguration }
    }
}
