// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



class CreateChannelRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the channel.
     */
    val channelName: String? = builder.channelName
    /**
     * Where channel data is stored. You can choose one of serviceManagedS3 or
     * customerManagedS3 storage. If not specified, the default is
     * serviceManagedS3. You can't change this storage option after the channel is
     * created.
     */
    val channelStorage: ChannelStorage? = builder.channelStorage
    /**
     * How long, in days, message data is kept for the channel. When
     * customerManagedS3 storage is selected, this parameter is ignored.
     */
    val retentionPeriod: RetentionPeriod? = builder.retentionPeriod
    /**
     * Metadata which can be used to manage the channel.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateChannelRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateChannelRequest(")
        append("channelName=$channelName,")
        append("channelStorage=$channelStorage,")
        append("retentionPeriod=$retentionPeriod,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelName?.hashCode() ?: 0
        result = 31 * result + (channelStorage?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateChannelRequest

        if (channelName != other.channelName) return false
        if (channelStorage != other.channelStorage) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateChannelRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateChannelRequest
        /**
         * The name of the channel.
         */
        fun channelName(channelName: String): FluentBuilder
        /**
         * Where channel data is stored. You can choose one of serviceManagedS3 or
         * customerManagedS3 storage. If not specified, the default is
         * serviceManagedS3. You can't change this storage option after the channel is
         * created.
         */
        fun channelStorage(channelStorage: ChannelStorage): FluentBuilder
        /**
         * How long, in days, message data is kept for the channel. When
         * customerManagedS3 storage is selected, this parameter is ignored.
         */
        fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder
        /**
         * Metadata which can be used to manage the channel.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the channel.
         */
        var channelName: String?
        /**
         * Where channel data is stored. You can choose one of serviceManagedS3 or
         * customerManagedS3 storage. If not specified, the default is
         * serviceManagedS3. You can't change this storage option after the channel is
         * created.
         */
        var channelStorage: ChannelStorage?
        /**
         * How long, in days, message data is kept for the channel. When
         * customerManagedS3 storage is selected, this parameter is ignored.
         */
        var retentionPeriod: RetentionPeriod?
        /**
         * Metadata which can be used to manage the channel.
         */
        var tags: List<Tag>?

        fun build(): CreateChannelRequest
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.ChannelStorage] inside the given [block]
         */
        fun channelStorage(block: ChannelStorage.DslBuilder.() -> kotlin.Unit) {
            this.channelStorage = ChannelStorage.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod] inside the given [block]
         */
        fun retentionPeriod(block: RetentionPeriod.DslBuilder.() -> kotlin.Unit) {
            this.retentionPeriod = RetentionPeriod.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var channelName: String? = null
        override var channelStorage: ChannelStorage? = null
        override var retentionPeriod: RetentionPeriod? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateChannelRequest) : this() {
            this.channelName = x.channelName
            this.channelStorage = x.channelStorage
            this.retentionPeriod = x.retentionPeriod
            this.tags = x.tags
        }

        override fun build(): CreateChannelRequest = CreateChannelRequest(this)
        override fun channelName(channelName: String): FluentBuilder = apply { this.channelName = channelName }
        override fun channelStorage(channelStorage: ChannelStorage): FluentBuilder = apply { this.channelStorage = channelStorage }
        override fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder = apply { this.retentionPeriod = retentionPeriod }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
