// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



/**
 * Information required to run the containerAction to produce dataset
 * contents.
 */
class ContainerDatasetAction private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the role that gives permission to the system to access required resources to
     * run the containerAction. This includes, at minimum, permission to retrieve the
     * dataset contents that are the input to the containerized application.
     */
    val executionRoleArn: String? = builder.executionRoleArn
    /**
     * The ARN of the Docker container stored in your account. The Docker container contains an
     * application and required support libraries and is used to generate dataset contents.
     */
    val image: String? = builder.image
    /**
     * Configuration of the resource that executes the containerAction.
     */
    val resourceConfiguration: ResourceConfiguration? = builder.resourceConfiguration
    /**
     * The values of variables used in the context of the execution of the containerized
     * application (basically, parameters passed to the application). Each variable must have a name
     * and a value given by one of stringValue, datasetContentVersionValue,
     * or outputFileUriValue.
     */
    val variables: List<Variable>? = builder.variables

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ContainerDatasetAction = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerDatasetAction(")
        append("executionRoleArn=$executionRoleArn,")
        append("image=$image,")
        append("resourceConfiguration=$resourceConfiguration,")
        append("variables=$variables)")
    }

    override fun hashCode(): kotlin.Int {
        var result = executionRoleArn?.hashCode() ?: 0
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (resourceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (variables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ContainerDatasetAction

        if (executionRoleArn != other.executionRoleArn) return false
        if (image != other.image) return false
        if (resourceConfiguration != other.resourceConfiguration) return false
        if (variables != other.variables) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ContainerDatasetAction = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ContainerDatasetAction
        /**
         * The ARN of the role that gives permission to the system to access required resources to
         * run the containerAction. This includes, at minimum, permission to retrieve the
         * dataset contents that are the input to the containerized application.
         */
        fun executionRoleArn(executionRoleArn: String): FluentBuilder
        /**
         * The ARN of the Docker container stored in your account. The Docker container contains an
         * application and required support libraries and is used to generate dataset contents.
         */
        fun image(image: String): FluentBuilder
        /**
         * Configuration of the resource that executes the containerAction.
         */
        fun resourceConfiguration(resourceConfiguration: ResourceConfiguration): FluentBuilder
        /**
         * The values of variables used in the context of the execution of the containerized
         * application (basically, parameters passed to the application). Each variable must have a name
         * and a value given by one of stringValue, datasetContentVersionValue,
         * or outputFileUriValue.
         */
        fun variables(variables: List<Variable>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the role that gives permission to the system to access required resources to
         * run the containerAction. This includes, at minimum, permission to retrieve the
         * dataset contents that are the input to the containerized application.
         */
        var executionRoleArn: String?
        /**
         * The ARN of the Docker container stored in your account. The Docker container contains an
         * application and required support libraries and is used to generate dataset contents.
         */
        var image: String?
        /**
         * Configuration of the resource that executes the containerAction.
         */
        var resourceConfiguration: ResourceConfiguration?
        /**
         * The values of variables used in the context of the execution of the containerized
         * application (basically, parameters passed to the application). Each variable must have a name
         * and a value given by one of stringValue, datasetContentVersionValue,
         * or outputFileUriValue.
         */
        var variables: List<Variable>?

        fun build(): ContainerDatasetAction
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.ResourceConfiguration] inside the given [block]
         */
        fun resourceConfiguration(block: ResourceConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.resourceConfiguration = ResourceConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var executionRoleArn: String? = null
        override var image: String? = null
        override var resourceConfiguration: ResourceConfiguration? = null
        override var variables: List<Variable>? = null

        constructor(x: ContainerDatasetAction) : this() {
            this.executionRoleArn = x.executionRoleArn
            this.image = x.image
            this.resourceConfiguration = x.resourceConfiguration
            this.variables = x.variables
        }

        override fun build(): ContainerDatasetAction = ContainerDatasetAction(this)
        override fun executionRoleArn(executionRoleArn: String): FluentBuilder = apply { this.executionRoleArn = executionRoleArn }
        override fun image(image: String): FluentBuilder = apply { this.image = image }
        override fun resourceConfiguration(resourceConfiguration: ResourceConfiguration): FluentBuilder = apply { this.resourceConfiguration = resourceConfiguration }
        override fun variables(variables: List<Variable>): FluentBuilder = apply { this.variables = variables }
    }
}
