// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of information about a channel.
 */
class ChannelSummary private constructor(builder: BuilderImpl) {
    /**
     * The name of the channel.
     */
    val channelName: String? = builder.channelName
    /**
     * Where channel data is stored.
     */
    val channelStorage: ChannelStorageSummary? = builder.channelStorage
    /**
     * When the channel was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The last time when a new message arrived in the channel.
     * IoT Analytics updates this value at most once per minute for one channel. Hence, the lastMessageArrivalTime value is an approximation.
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     */
    val lastMessageArrivalTime: Instant? = builder.lastMessageArrivalTime
    /**
     * The last time the channel was updated.
     */
    val lastUpdateTime: Instant? = builder.lastUpdateTime
    /**
     * The status of the channel.
     */
    val status: ChannelStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ChannelSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ChannelSummary(")
        append("channelName=$channelName,")
        append("channelStorage=$channelStorage,")
        append("creationTime=$creationTime,")
        append("lastMessageArrivalTime=$lastMessageArrivalTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelName?.hashCode() ?: 0
        result = 31 * result + (channelStorage?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastMessageArrivalTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ChannelSummary

        if (channelName != other.channelName) return false
        if (channelStorage != other.channelStorage) return false
        if (creationTime != other.creationTime) return false
        if (lastMessageArrivalTime != other.lastMessageArrivalTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ChannelSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ChannelSummary
        /**
         * The name of the channel.
         */
        fun channelName(channelName: String): FluentBuilder
        /**
         * Where channel data is stored.
         */
        fun channelStorage(channelStorage: ChannelStorageSummary): FluentBuilder
        /**
         * When the channel was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The last time when a new message arrived in the channel.
         * IoT Analytics updates this value at most once per minute for one channel. Hence, the lastMessageArrivalTime value is an approximation.
         * This feature only applies to messages that arrived in the data store after October 23, 2020.
         */
        fun lastMessageArrivalTime(lastMessageArrivalTime: Instant): FluentBuilder
        /**
         * The last time the channel was updated.
         */
        fun lastUpdateTime(lastUpdateTime: Instant): FluentBuilder
        /**
         * The status of the channel.
         */
        fun status(status: ChannelStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the channel.
         */
        var channelName: String?
        /**
         * Where channel data is stored.
         */
        var channelStorage: ChannelStorageSummary?
        /**
         * When the channel was created.
         */
        var creationTime: Instant?
        /**
         * The last time when a new message arrived in the channel.
         * IoT Analytics updates this value at most once per minute for one channel. Hence, the lastMessageArrivalTime value is an approximation.
         * This feature only applies to messages that arrived in the data store after October 23, 2020.
         */
        var lastMessageArrivalTime: Instant?
        /**
         * The last time the channel was updated.
         */
        var lastUpdateTime: Instant?
        /**
         * The status of the channel.
         */
        var status: ChannelStatus?

        fun build(): ChannelSummary
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.ChannelStorageSummary] inside the given [block]
         */
        fun channelStorage(block: ChannelStorageSummary.DslBuilder.() -> kotlin.Unit) {
            this.channelStorage = ChannelStorageSummary.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var channelName: String? = null
        override var channelStorage: ChannelStorageSummary? = null
        override var creationTime: Instant? = null
        override var lastMessageArrivalTime: Instant? = null
        override var lastUpdateTime: Instant? = null
        override var status: ChannelStatus? = null

        constructor(x: ChannelSummary) : this() {
            this.channelName = x.channelName
            this.channelStorage = x.channelStorage
            this.creationTime = x.creationTime
            this.lastMessageArrivalTime = x.lastMessageArrivalTime
            this.lastUpdateTime = x.lastUpdateTime
            this.status = x.status
        }

        override fun build(): ChannelSummary = ChannelSummary(this)
        override fun channelName(channelName: String): FluentBuilder = apply { this.channelName = channelName }
        override fun channelStorage(channelStorage: ChannelStorageSummary): FluentBuilder = apply { this.channelStorage = channelStorage }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun lastMessageArrivalTime(lastMessageArrivalTime: Instant): FluentBuilder = apply { this.lastMessageArrivalTime = lastMessageArrivalTime }
        override fun lastUpdateTime(lastUpdateTime: Instant): FluentBuilder = apply { this.lastUpdateTime = lastUpdateTime }
        override fun status(status: ChannelStatus): FluentBuilder = apply { this.status = status }
    }
}
