// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A collection of data from an MQTT topic. Channels archive the raw, unprocessed messages
 * before publishing the data to a pipeline.
 */
class Channel private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the channel.
     */
    val arn: String? = builder.arn
    /**
     * When the channel was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The last time when a new message arrived in the channel.
     * IoT Analytics updates this value at most once per minute for one channel. Hence, the lastMessageArrivalTime value is an approximation.
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     */
    val lastMessageArrivalTime: Instant? = builder.lastMessageArrivalTime
    /**
     * When the channel was last updated.
     */
    val lastUpdateTime: Instant? = builder.lastUpdateTime
    /**
     * The name of the channel.
     */
    val name: String? = builder.name
    /**
     * How long, in days, message data is kept for the channel.
     */
    val retentionPeriod: RetentionPeriod? = builder.retentionPeriod
    /**
     * The status of the channel.
     */
    val status: ChannelStatus? = builder.status
    /**
     * Where channel data is stored. You can choose one of serviceManagedS3 or
     * customerManagedS3 storage. If not specified, the default is
     * serviceManagedS3. You can't change this storage option after the channel is
     * created.
     */
    val storage: ChannelStorage? = builder.storage

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Channel = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Channel(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("lastMessageArrivalTime=$lastMessageArrivalTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("name=$name,")
        append("retentionPeriod=$retentionPeriod,")
        append("status=$status,")
        append("storage=$storage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastMessageArrivalTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Channel

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (lastMessageArrivalTime != other.lastMessageArrivalTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (name != other.name) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (status != other.status) return false
        if (storage != other.storage) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Channel = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Channel
        /**
         * The ARN of the channel.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * When the channel was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The last time when a new message arrived in the channel.
         * IoT Analytics updates this value at most once per minute for one channel. Hence, the lastMessageArrivalTime value is an approximation.
         * This feature only applies to messages that arrived in the data store after October 23, 2020.
         */
        fun lastMessageArrivalTime(lastMessageArrivalTime: Instant): FluentBuilder
        /**
         * When the channel was last updated.
         */
        fun lastUpdateTime(lastUpdateTime: Instant): FluentBuilder
        /**
         * The name of the channel.
         */
        fun name(name: String): FluentBuilder
        /**
         * How long, in days, message data is kept for the channel.
         */
        fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder
        /**
         * The status of the channel.
         */
        fun status(status: ChannelStatus): FluentBuilder
        /**
         * Where channel data is stored. You can choose one of serviceManagedS3 or
         * customerManagedS3 storage. If not specified, the default is
         * serviceManagedS3. You can't change this storage option after the channel is
         * created.
         */
        fun storage(storage: ChannelStorage): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the channel.
         */
        var arn: String?
        /**
         * When the channel was created.
         */
        var creationTime: Instant?
        /**
         * The last time when a new message arrived in the channel.
         * IoT Analytics updates this value at most once per minute for one channel. Hence, the lastMessageArrivalTime value is an approximation.
         * This feature only applies to messages that arrived in the data store after October 23, 2020.
         */
        var lastMessageArrivalTime: Instant?
        /**
         * When the channel was last updated.
         */
        var lastUpdateTime: Instant?
        /**
         * The name of the channel.
         */
        var name: String?
        /**
         * How long, in days, message data is kept for the channel.
         */
        var retentionPeriod: RetentionPeriod?
        /**
         * The status of the channel.
         */
        var status: ChannelStatus?
        /**
         * Where channel data is stored. You can choose one of serviceManagedS3 or
         * customerManagedS3 storage. If not specified, the default is
         * serviceManagedS3. You can't change this storage option after the channel is
         * created.
         */
        var storage: ChannelStorage?

        fun build(): Channel
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod] inside the given [block]
         */
        fun retentionPeriod(block: RetentionPeriod.DslBuilder.() -> kotlin.Unit) {
            this.retentionPeriod = RetentionPeriod.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.ChannelStorage] inside the given [block]
         */
        fun storage(block: ChannelStorage.DslBuilder.() -> kotlin.Unit) {
            this.storage = ChannelStorage.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var creationTime: Instant? = null
        override var lastMessageArrivalTime: Instant? = null
        override var lastUpdateTime: Instant? = null
        override var name: String? = null
        override var retentionPeriod: RetentionPeriod? = null
        override var status: ChannelStatus? = null
        override var storage: ChannelStorage? = null

        constructor(x: Channel) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.lastMessageArrivalTime = x.lastMessageArrivalTime
            this.lastUpdateTime = x.lastUpdateTime
            this.name = x.name
            this.retentionPeriod = x.retentionPeriod
            this.status = x.status
            this.storage = x.storage
        }

        override fun build(): Channel = Channel(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun lastMessageArrivalTime(lastMessageArrivalTime: Instant): FluentBuilder = apply { this.lastMessageArrivalTime = lastMessageArrivalTime }
        override fun lastUpdateTime(lastUpdateTime: Instant): FluentBuilder = apply { this.lastUpdateTime = lastUpdateTime }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun retentionPeriod(retentionPeriod: RetentionPeriod): FluentBuilder = apply { this.retentionPeriod = retentionPeriod }
        override fun status(status: ChannelStatus): FluentBuilder = apply { this.status = status }
        override fun storage(storage: ChannelStorage): FluentBuilder = apply { this.storage = storage }
    }
}
