// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics

import aws.sdk.kotlin.runtime.auth.AuthConfig
import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.runtime.region.RegionConfig
import aws.sdk.kotlin.services.iotanalytics.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * IoT Analytics allows you to collect large amounts of device data, process messages, and store them.
 * You can then query the data and run sophisticated analytics on it.  IoT Analytics enables advanced
 * data exploration through integration with Jupyter Notebooks and data visualization through integration
 * with Amazon QuickSight.
 * Traditional analytics and business intelligence tools are designed to process structured data. IoT data
 * often comes from devices that record noisy processes (such as temperature, motion, or sound). As a result
 * the data from these devices can have significant gaps, corrupted messages, and false readings that must be
 * cleaned up before analysis can occur. Also, IoT data is often only meaningful in the context of other data
 * from external sources.
 * IoT Analytics automates the steps required to analyze data from IoT devices. IoT Analytics
 * filters, transforms, and enriches IoT data before storing it in a time-series data store for analysis. You
 * can set up the service to collect only the data you need from your devices, apply mathematical transforms
 * to process the data, and enrich the data with device-specific metadata such as device type and location
 * before storing it. Then, you can analyze your data by running queries using the built-in SQL query engine,
 * or perform more complex analytics and machine learning inference. IoT Analytics includes pre-built models
 * for common IoT use cases so you can answer questions like which devices are about to fail or which customers
 * are at risk of abandoning their wearable devices.
 */
interface IoTAnalyticsClient : SdkClient {

    override val serviceName: String
        get() = "IoTAnalytics"
    /**
     * IoTAnalyticsClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.DslBuilder.() -> Unit = {}): IoTAnalyticsClient {
            val config = Config.BuilderImpl().apply(block).build()
            return DefaultIoTAnalyticsClient(config)
        }
    }

    class Config private constructor(builder: BuilderImpl): AuthConfig, HttpClientConfig, RegionConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider? = builder.credentialsProvider
        val endpointResolver: EndpointResolver? = builder.endpointResolver
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String? = builder.region
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val signingRegion: String? = builder.signingRegion

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun signingRegion(signingRegion: String): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client configuration (e.g. configure proxy behavior, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

            /**
             * AWS region to be used for signing the request. This is not necessarily the same as `region`
             * in the case of global services like IAM
             */
            var signingRegion: String?

            fun build(): Config
        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default
            override var signingRegion: String? = null

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
            override fun signingRegion(signingRegion: String): FluentBuilder = apply { this.signingRegion = signingRegion }
        }
    }

    /**
     * Sends messages to a channel.
     */
    suspend fun batchPutMessage(input: BatchPutMessageRequest): BatchPutMessageResponse

    /**
     * Sends messages to a channel.
     */
    suspend fun batchPutMessage(block: BatchPutMessageRequest.DslBuilder.() -> Unit) = batchPutMessage(BatchPutMessageRequest.builder().apply(block).build())

    /**
     * Cancels the reprocessing of data through the pipeline.
     */
    suspend fun cancelPipelineReprocessing(input: CancelPipelineReprocessingRequest): CancelPipelineReprocessingResponse

    /**
     * Cancels the reprocessing of data through the pipeline.
     */
    suspend fun cancelPipelineReprocessing(block: CancelPipelineReprocessingRequest.DslBuilder.() -> Unit) = cancelPipelineReprocessing(CancelPipelineReprocessingRequest.builder().apply(block).build())

    /**
     * Used to create a channel. A channel collects data from an MQTT topic and archives the raw,
     * unprocessed messages before publishing the data to a pipeline.
     */
    suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse

    /**
     * Used to create a channel. A channel collects data from an MQTT topic and archives the raw,
     * unprocessed messages before publishing the data to a pipeline.
     */
    suspend fun createChannel(block: CreateChannelRequest.DslBuilder.() -> Unit) = createChannel(CreateChannelRequest.builder().apply(block).build())

    /**
     * Used to create a dataset. A dataset stores data retrieved from a data store by applying a
     * queryAction (a SQL query) or a containerAction (executing a
     * containerized application). This operation creates the skeleton of a dataset. The dataset can
     * be populated manually by calling CreateDatasetContent or automatically according
     * to a trigger you specify.
     */
    suspend fun createDataset(input: CreateDatasetRequest): CreateDatasetResponse

    /**
     * Used to create a dataset. A dataset stores data retrieved from a data store by applying a
     * queryAction (a SQL query) or a containerAction (executing a
     * containerized application). This operation creates the skeleton of a dataset. The dataset can
     * be populated manually by calling CreateDatasetContent or automatically according
     * to a trigger you specify.
     */
    suspend fun createDataset(block: CreateDatasetRequest.DslBuilder.() -> Unit) = createDataset(CreateDatasetRequest.builder().apply(block).build())

    /**
     * Creates the content of a dataset by applying a queryAction (a SQL query) or a
     * containerAction (executing a containerized application).
     */
    suspend fun createDatasetContent(input: CreateDatasetContentRequest): CreateDatasetContentResponse

    /**
     * Creates the content of a dataset by applying a queryAction (a SQL query) or a
     * containerAction (executing a containerized application).
     */
    suspend fun createDatasetContent(block: CreateDatasetContentRequest.DslBuilder.() -> Unit) = createDatasetContent(CreateDatasetContentRequest.builder().apply(block).build())

    /**
     * Creates a data store, which is a repository for messages.
     */
    suspend fun createDatastore(input: CreateDatastoreRequest): CreateDatastoreResponse

    /**
     * Creates a data store, which is a repository for messages.
     */
    suspend fun createDatastore(block: CreateDatastoreRequest.DslBuilder.() -> Unit) = createDatastore(CreateDatastoreRequest.builder().apply(block).build())

    /**
     * Creates a pipeline. A pipeline consumes messages from a channel and allows you to process
     * the messages before storing them in a data store. You must specify both a channel
     * and a datastore activity and, optionally, as many as 23 additional activities in
     * the pipelineActivities array.
     */
    suspend fun createPipeline(input: CreatePipelineRequest): CreatePipelineResponse

    /**
     * Creates a pipeline. A pipeline consumes messages from a channel and allows you to process
     * the messages before storing them in a data store. You must specify both a channel
     * and a datastore activity and, optionally, as many as 23 additional activities in
     * the pipelineActivities array.
     */
    suspend fun createPipeline(block: CreatePipelineRequest.DslBuilder.() -> Unit) = createPipeline(CreatePipelineRequest.builder().apply(block).build())

    /**
     * Deletes the specified channel.
     */
    suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * Deletes the specified channel.
     */
    suspend fun deleteChannel(block: DeleteChannelRequest.DslBuilder.() -> Unit) = deleteChannel(DeleteChannelRequest.builder().apply(block).build())

    /**
     * Deletes the specified dataset.
     * You do not have to delete the content of the dataset before you perform this
     * operation.
     */
    suspend fun deleteDataset(input: DeleteDatasetRequest): DeleteDatasetResponse

    /**
     * Deletes the specified dataset.
     * You do not have to delete the content of the dataset before you perform this
     * operation.
     */
    suspend fun deleteDataset(block: DeleteDatasetRequest.DslBuilder.() -> Unit) = deleteDataset(DeleteDatasetRequest.builder().apply(block).build())

    /**
     * Deletes the content of the specified dataset.
     */
    suspend fun deleteDatasetContent(input: DeleteDatasetContentRequest): DeleteDatasetContentResponse

    /**
     * Deletes the content of the specified dataset.
     */
    suspend fun deleteDatasetContent(block: DeleteDatasetContentRequest.DslBuilder.() -> Unit) = deleteDatasetContent(DeleteDatasetContentRequest.builder().apply(block).build())

    /**
     * Deletes the specified data store.
     */
    suspend fun deleteDatastore(input: DeleteDatastoreRequest): DeleteDatastoreResponse

    /**
     * Deletes the specified data store.
     */
    suspend fun deleteDatastore(block: DeleteDatastoreRequest.DslBuilder.() -> Unit) = deleteDatastore(DeleteDatastoreRequest.builder().apply(block).build())

    /**
     * Deletes the specified pipeline.
     */
    suspend fun deletePipeline(input: DeletePipelineRequest): DeletePipelineResponse

    /**
     * Deletes the specified pipeline.
     */
    suspend fun deletePipeline(block: DeletePipelineRequest.DslBuilder.() -> Unit) = deletePipeline(DeletePipelineRequest.builder().apply(block).build())

    /**
     * Retrieves information about a channel.
     */
    suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse

    /**
     * Retrieves information about a channel.
     */
    suspend fun describeChannel(block: DescribeChannelRequest.DslBuilder.() -> Unit) = describeChannel(DescribeChannelRequest.builder().apply(block).build())

    /**
     * Retrieves information about a dataset.
     */
    suspend fun describeDataset(input: DescribeDatasetRequest): DescribeDatasetResponse

    /**
     * Retrieves information about a dataset.
     */
    suspend fun describeDataset(block: DescribeDatasetRequest.DslBuilder.() -> Unit) = describeDataset(DescribeDatasetRequest.builder().apply(block).build())

    /**
     * Retrieves information about a data store.
     */
    suspend fun describeDatastore(input: DescribeDatastoreRequest): DescribeDatastoreResponse

    /**
     * Retrieves information about a data store.
     */
    suspend fun describeDatastore(block: DescribeDatastoreRequest.DslBuilder.() -> Unit) = describeDatastore(DescribeDatastoreRequest.builder().apply(block).build())

    /**
     * Retrieves the current settings of the IoT Analytics logging options.
     */
    suspend fun describeLoggingOptions(input: DescribeLoggingOptionsRequest): DescribeLoggingOptionsResponse

    /**
     * Retrieves the current settings of the IoT Analytics logging options.
     */
    suspend fun describeLoggingOptions(block: DescribeLoggingOptionsRequest.DslBuilder.() -> Unit) = describeLoggingOptions(DescribeLoggingOptionsRequest.builder().apply(block).build())

    /**
     * Retrieves information about a pipeline.
     */
    suspend fun describePipeline(input: DescribePipelineRequest): DescribePipelineResponse

    /**
     * Retrieves information about a pipeline.
     */
    suspend fun describePipeline(block: DescribePipelineRequest.DslBuilder.() -> Unit) = describePipeline(DescribePipelineRequest.builder().apply(block).build())

    /**
     * Retrieves the contents of a dataset as presigned URIs.
     */
    suspend fun getDatasetContent(input: GetDatasetContentRequest): GetDatasetContentResponse

    /**
     * Retrieves the contents of a dataset as presigned URIs.
     */
    suspend fun getDatasetContent(block: GetDatasetContentRequest.DslBuilder.() -> Unit) = getDatasetContent(GetDatasetContentRequest.builder().apply(block).build())

    /**
     * Retrieves a list of channels.
     */
    suspend fun listChannels(input: ListChannelsRequest): ListChannelsResponse

    /**
     * Retrieves a list of channels.
     */
    suspend fun listChannels(block: ListChannelsRequest.DslBuilder.() -> Unit) = listChannels(ListChannelsRequest.builder().apply(block).build())

    /**
     * Lists information about dataset contents that have been created.
     */
    suspend fun listDatasetContents(input: ListDatasetContentsRequest): ListDatasetContentsResponse

    /**
     * Lists information about dataset contents that have been created.
     */
    suspend fun listDatasetContents(block: ListDatasetContentsRequest.DslBuilder.() -> Unit) = listDatasetContents(ListDatasetContentsRequest.builder().apply(block).build())

    /**
     * Retrieves information about datasets.
     */
    suspend fun listDatasets(input: ListDatasetsRequest): ListDatasetsResponse

    /**
     * Retrieves information about datasets.
     */
    suspend fun listDatasets(block: ListDatasetsRequest.DslBuilder.() -> Unit) = listDatasets(ListDatasetsRequest.builder().apply(block).build())

    /**
     * Retrieves a list of data stores.
     */
    suspend fun listDatastores(input: ListDatastoresRequest): ListDatastoresResponse

    /**
     * Retrieves a list of data stores.
     */
    suspend fun listDatastores(block: ListDatastoresRequest.DslBuilder.() -> Unit) = listDatastores(ListDatastoresRequest.builder().apply(block).build())

    /**
     * Retrieves a list of pipelines.
     */
    suspend fun listPipelines(input: ListPipelinesRequest): ListPipelinesResponse

    /**
     * Retrieves a list of pipelines.
     */
    suspend fun listPipelines(block: ListPipelinesRequest.DslBuilder.() -> Unit) = listPipelines(ListPipelinesRequest.builder().apply(block).build())

    /**
     * Lists the tags (metadata) that you have assigned to the resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags (metadata) that you have assigned to the resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Sets or updates the IoT Analytics logging options.
     * If you update the value of any loggingOptions field, it takes up to one
     * minute for the change to take effect. Also, if you change the policy attached to the role you
     * specified in the roleArn field (for example, to correct an invalid policy), it
     * takes up to five minutes for that change to take effect.
     */
    suspend fun putLoggingOptions(input: PutLoggingOptionsRequest): PutLoggingOptionsResponse

    /**
     * Sets or updates the IoT Analytics logging options.
     * If you update the value of any loggingOptions field, it takes up to one
     * minute for the change to take effect. Also, if you change the policy attached to the role you
     * specified in the roleArn field (for example, to correct an invalid policy), it
     * takes up to five minutes for that change to take effect.
     */
    suspend fun putLoggingOptions(block: PutLoggingOptionsRequest.DslBuilder.() -> Unit) = putLoggingOptions(PutLoggingOptionsRequest.builder().apply(block).build())

    /**
     * Simulates the results of running a pipeline activity on a message payload.
     */
    suspend fun runPipelineActivity(input: RunPipelineActivityRequest): RunPipelineActivityResponse

    /**
     * Simulates the results of running a pipeline activity on a message payload.
     */
    suspend fun runPipelineActivity(block: RunPipelineActivityRequest.DslBuilder.() -> Unit) = runPipelineActivity(RunPipelineActivityRequest.builder().apply(block).build())

    /**
     * Retrieves a sample of messages from the specified channel ingested during the specified
     * timeframe. Up to 10 messages can be retrieved.
     */
    suspend fun sampleChannelData(input: SampleChannelDataRequest): SampleChannelDataResponse

    /**
     * Retrieves a sample of messages from the specified channel ingested during the specified
     * timeframe. Up to 10 messages can be retrieved.
     */
    suspend fun sampleChannelData(block: SampleChannelDataRequest.DslBuilder.() -> Unit) = sampleChannelData(SampleChannelDataRequest.builder().apply(block).build())

    /**
     * Starts the reprocessing of raw message data through the pipeline.
     */
    suspend fun startPipelineReprocessing(input: StartPipelineReprocessingRequest): StartPipelineReprocessingResponse

    /**
     * Starts the reprocessing of raw message data through the pipeline.
     */
    suspend fun startPipelineReprocessing(block: StartPipelineReprocessingRequest.DslBuilder.() -> Unit) = startPipelineReprocessing(StartPipelineReprocessingRequest.builder().apply(block).build())

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to
     * manage a resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to
     * manage a resource.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Removes the given tags (metadata) from the resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the given tags (metadata) from the resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Used to update the settings of a channel.
     */
    suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse

    /**
     * Used to update the settings of a channel.
     */
    suspend fun updateChannel(block: UpdateChannelRequest.DslBuilder.() -> Unit) = updateChannel(UpdateChannelRequest.builder().apply(block).build())

    /**
     * Updates the settings of a dataset.
     */
    suspend fun updateDataset(input: UpdateDatasetRequest): UpdateDatasetResponse

    /**
     * Updates the settings of a dataset.
     */
    suspend fun updateDataset(block: UpdateDatasetRequest.DslBuilder.() -> Unit) = updateDataset(UpdateDatasetRequest.builder().apply(block).build())

    /**
     * Used to update the settings of a data store.
     */
    suspend fun updateDatastore(input: UpdateDatastoreRequest): UpdateDatastoreResponse

    /**
     * Used to update the settings of a data store.
     */
    suspend fun updateDatastore(block: UpdateDatastoreRequest.DslBuilder.() -> Unit) = updateDatastore(UpdateDatastoreRequest.builder().apply(block).build())

    /**
     * Updates the settings of a pipeline. You must specify both a channel and a
     * datastore activity and, optionally, as many as 23 additional activities in the
     * pipelineActivities array.
     */
    suspend fun updatePipeline(input: UpdatePipelineRequest): UpdatePipelineResponse

    /**
     * Updates the settings of a pipeline. You must specify both a channel and a
     * datastore activity and, optionally, as many as 23 additional activities in the
     * pipelineActivities array.
     */
    suspend fun updatePipeline(block: UpdatePipelineRequest.DslBuilder.() -> Unit) = updatePipeline(UpdatePipelineRequest.builder().apply(block).build())
}
