// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.region.resolveRegionForOperation
import aws.sdk.kotlin.services.iotanalytics.model.*
import aws.sdk.kotlin.services.iotanalytics.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngineConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "IoTAnalytics"
const val ServiceApiVersion: String = "2017-11-27"
const val SdkVersion: String = "0.7.0-alpha"

internal class DefaultIoTAnalyticsClient(override val config: IoTAnalyticsClient.Config) : IoTAnalyticsClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Sends messages to a channel.
     */
    override suspend fun batchPutMessage(input: BatchPutMessageRequest): BatchPutMessageResponse {
        val op = SdkHttpOperation.build<BatchPutMessageRequest, BatchPutMessageResponse> {
            serializer = BatchPutMessageOperationSerializer()
            deserializer = BatchPutMessageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchPutMessage"
            }
        }
        registerBatchPutMessageMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels the reprocessing of data through the pipeline.
     */
    override suspend fun cancelPipelineReprocessing(input: CancelPipelineReprocessingRequest): CancelPipelineReprocessingResponse {
        val op = SdkHttpOperation.build<CancelPipelineReprocessingRequest, CancelPipelineReprocessingResponse> {
            serializer = CancelPipelineReprocessingOperationSerializer()
            deserializer = CancelPipelineReprocessingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelPipelineReprocessing"
            }
        }
        registerCancelPipelineReprocessingMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Used to create a channel. A channel collects data from an MQTT topic and archives the raw,
     * unprocessed messages before publishing the data to a pipeline.
     */
    override suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse {
        val op = SdkHttpOperation.build<CreateChannelRequest, CreateChannelResponse> {
            serializer = CreateChannelOperationSerializer()
            deserializer = CreateChannelOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateChannel"
            }
        }
        registerCreateChannelMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Used to create a dataset. A dataset stores data retrieved from a data store by applying a
     * queryAction (a SQL query) or a containerAction (executing a
     * containerized application). This operation creates the skeleton of a dataset. The dataset can
     * be populated manually by calling CreateDatasetContent or automatically according
     * to a trigger you specify.
     */
    override suspend fun createDataset(input: CreateDatasetRequest): CreateDatasetResponse {
        val op = SdkHttpOperation.build<CreateDatasetRequest, CreateDatasetResponse> {
            serializer = CreateDatasetOperationSerializer()
            deserializer = CreateDatasetOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateDataset"
            }
        }
        registerCreateDatasetMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates the content of a dataset by applying a queryAction (a SQL query) or a
     * containerAction (executing a containerized application).
     */
    override suspend fun createDatasetContent(input: CreateDatasetContentRequest): CreateDatasetContentResponse {
        val op = SdkHttpOperation.build<CreateDatasetContentRequest, CreateDatasetContentResponse> {
            serializer = CreateDatasetContentOperationSerializer()
            deserializer = CreateDatasetContentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDatasetContent"
            }
        }
        registerCreateDatasetContentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a data store, which is a repository for messages.
     */
    override suspend fun createDatastore(input: CreateDatastoreRequest): CreateDatastoreResponse {
        val op = SdkHttpOperation.build<CreateDatastoreRequest, CreateDatastoreResponse> {
            serializer = CreateDatastoreOperationSerializer()
            deserializer = CreateDatastoreOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateDatastore"
            }
        }
        registerCreateDatastoreMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a pipeline. A pipeline consumes messages from a channel and allows you to process
     * the messages before storing them in a data store. You must specify both a channel
     * and a datastore activity and, optionally, as many as 23 additional activities in
     * the pipelineActivities array.
     */
    override suspend fun createPipeline(input: CreatePipelineRequest): CreatePipelineResponse {
        val op = SdkHttpOperation.build<CreatePipelineRequest, CreatePipelineResponse> {
            serializer = CreatePipelineOperationSerializer()
            deserializer = CreatePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreatePipeline"
            }
        }
        registerCreatePipelineMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified channel.
     */
    override suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse {
        val op = SdkHttpOperation.build<DeleteChannelRequest, DeleteChannelResponse> {
            serializer = DeleteChannelOperationSerializer()
            deserializer = DeleteChannelOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteChannel"
            }
        }
        registerDeleteChannelMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified dataset.
     * You do not have to delete the content of the dataset before you perform this
     * operation.
     */
    override suspend fun deleteDataset(input: DeleteDatasetRequest): DeleteDatasetResponse {
        val op = SdkHttpOperation.build<DeleteDatasetRequest, DeleteDatasetResponse> {
            serializer = DeleteDatasetOperationSerializer()
            deserializer = DeleteDatasetOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteDataset"
            }
        }
        registerDeleteDatasetMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the content of the specified dataset.
     */
    override suspend fun deleteDatasetContent(input: DeleteDatasetContentRequest): DeleteDatasetContentResponse {
        val op = SdkHttpOperation.build<DeleteDatasetContentRequest, DeleteDatasetContentResponse> {
            serializer = DeleteDatasetContentOperationSerializer()
            deserializer = DeleteDatasetContentOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteDatasetContent"
            }
        }
        registerDeleteDatasetContentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified data store.
     */
    override suspend fun deleteDatastore(input: DeleteDatastoreRequest): DeleteDatastoreResponse {
        val op = SdkHttpOperation.build<DeleteDatastoreRequest, DeleteDatastoreResponse> {
            serializer = DeleteDatastoreOperationSerializer()
            deserializer = DeleteDatastoreOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteDatastore"
            }
        }
        registerDeleteDatastoreMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified pipeline.
     */
    override suspend fun deletePipeline(input: DeletePipelineRequest): DeletePipelineResponse {
        val op = SdkHttpOperation.build<DeletePipelineRequest, DeletePipelineResponse> {
            serializer = DeletePipelineOperationSerializer()
            deserializer = DeletePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeletePipeline"
            }
        }
        registerDeletePipelineMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a channel.
     */
    override suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse {
        val op = SdkHttpOperation.build<DescribeChannelRequest, DescribeChannelResponse> {
            serializer = DescribeChannelOperationSerializer()
            deserializer = DescribeChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeChannel"
            }
        }
        registerDescribeChannelMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a dataset.
     */
    override suspend fun describeDataset(input: DescribeDatasetRequest): DescribeDatasetResponse {
        val op = SdkHttpOperation.build<DescribeDatasetRequest, DescribeDatasetResponse> {
            serializer = DescribeDatasetOperationSerializer()
            deserializer = DescribeDatasetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDataset"
            }
        }
        registerDescribeDatasetMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a data store.
     */
    override suspend fun describeDatastore(input: DescribeDatastoreRequest): DescribeDatastoreResponse {
        val op = SdkHttpOperation.build<DescribeDatastoreRequest, DescribeDatastoreResponse> {
            serializer = DescribeDatastoreOperationSerializer()
            deserializer = DescribeDatastoreOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDatastore"
            }
        }
        registerDescribeDatastoreMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the current settings of the IoT Analytics logging options.
     */
    override suspend fun describeLoggingOptions(input: DescribeLoggingOptionsRequest): DescribeLoggingOptionsResponse {
        val op = SdkHttpOperation.build<DescribeLoggingOptionsRequest, DescribeLoggingOptionsResponse> {
            serializer = DescribeLoggingOptionsOperationSerializer()
            deserializer = DescribeLoggingOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLoggingOptions"
            }
        }
        registerDescribeLoggingOptionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a pipeline.
     */
    override suspend fun describePipeline(input: DescribePipelineRequest): DescribePipelineResponse {
        val op = SdkHttpOperation.build<DescribePipelineRequest, DescribePipelineResponse> {
            serializer = DescribePipelineOperationSerializer()
            deserializer = DescribePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePipeline"
            }
        }
        registerDescribePipelineMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the contents of a dataset as presigned URIs.
     */
    override suspend fun getDatasetContent(input: GetDatasetContentRequest): GetDatasetContentResponse {
        val op = SdkHttpOperation.build<GetDatasetContentRequest, GetDatasetContentResponse> {
            serializer = GetDatasetContentOperationSerializer()
            deserializer = GetDatasetContentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDatasetContent"
            }
        }
        registerGetDatasetContentMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of channels.
     */
    override suspend fun listChannels(input: ListChannelsRequest): ListChannelsResponse {
        val op = SdkHttpOperation.build<ListChannelsRequest, ListChannelsResponse> {
            serializer = ListChannelsOperationSerializer()
            deserializer = ListChannelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListChannels"
            }
        }
        registerListChannelsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists information about dataset contents that have been created.
     */
    override suspend fun listDatasetContents(input: ListDatasetContentsRequest): ListDatasetContentsResponse {
        val op = SdkHttpOperation.build<ListDatasetContentsRequest, ListDatasetContentsResponse> {
            serializer = ListDatasetContentsOperationSerializer()
            deserializer = ListDatasetContentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDatasetContents"
            }
        }
        registerListDatasetContentsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about datasets.
     */
    override suspend fun listDatasets(input: ListDatasetsRequest): ListDatasetsResponse {
        val op = SdkHttpOperation.build<ListDatasetsRequest, ListDatasetsResponse> {
            serializer = ListDatasetsOperationSerializer()
            deserializer = ListDatasetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDatasets"
            }
        }
        registerListDatasetsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of data stores.
     */
    override suspend fun listDatastores(input: ListDatastoresRequest): ListDatastoresResponse {
        val op = SdkHttpOperation.build<ListDatastoresRequest, ListDatastoresResponse> {
            serializer = ListDatastoresOperationSerializer()
            deserializer = ListDatastoresOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDatastores"
            }
        }
        registerListDatastoresMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of pipelines.
     */
    override suspend fun listPipelines(input: ListPipelinesRequest): ListPipelinesResponse {
        val op = SdkHttpOperation.build<ListPipelinesRequest, ListPipelinesResponse> {
            serializer = ListPipelinesOperationSerializer()
            deserializer = ListPipelinesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPipelines"
            }
        }
        registerListPipelinesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags (metadata) that you have assigned to the resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Sets or updates the IoT Analytics logging options.
     * If you update the value of any loggingOptions field, it takes up to one
     * minute for the change to take effect. Also, if you change the policy attached to the role you
     * specified in the roleArn field (for example, to correct an invalid policy), it
     * takes up to five minutes for that change to take effect.
     */
    override suspend fun putLoggingOptions(input: PutLoggingOptionsRequest): PutLoggingOptionsResponse {
        val op = SdkHttpOperation.build<PutLoggingOptionsRequest, PutLoggingOptionsResponse> {
            serializer = PutLoggingOptionsOperationSerializer()
            deserializer = PutLoggingOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutLoggingOptions"
            }
        }
        registerPutLoggingOptionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Simulates the results of running a pipeline activity on a message payload.
     */
    override suspend fun runPipelineActivity(input: RunPipelineActivityRequest): RunPipelineActivityResponse {
        val op = SdkHttpOperation.build<RunPipelineActivityRequest, RunPipelineActivityResponse> {
            serializer = RunPipelineActivityOperationSerializer()
            deserializer = RunPipelineActivityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RunPipelineActivity"
            }
        }
        registerRunPipelineActivityMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a sample of messages from the specified channel ingested during the specified
     * timeframe. Up to 10 messages can be retrieved.
     */
    override suspend fun sampleChannelData(input: SampleChannelDataRequest): SampleChannelDataResponse {
        val op = SdkHttpOperation.build<SampleChannelDataRequest, SampleChannelDataResponse> {
            serializer = SampleChannelDataOperationSerializer()
            deserializer = SampleChannelDataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SampleChannelData"
            }
        }
        registerSampleChannelDataMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Starts the reprocessing of raw message data through the pipeline.
     */
    override suspend fun startPipelineReprocessing(input: StartPipelineReprocessingRequest): StartPipelineReprocessingResponse {
        val op = SdkHttpOperation.build<StartPipelineReprocessingRequest, StartPipelineReprocessingResponse> {
            serializer = StartPipelineReprocessingOperationSerializer()
            deserializer = StartPipelineReprocessingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartPipelineReprocessing"
            }
        }
        registerStartPipelineReprocessingMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to
     * manage a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        registerTagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the given tags (metadata) from the resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        registerUntagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Used to update the settings of a channel.
     */
    override suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse {
        val op = SdkHttpOperation.build<UpdateChannelRequest, UpdateChannelResponse> {
            serializer = UpdateChannelOperationSerializer()
            deserializer = UpdateChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateChannel"
            }
        }
        registerUpdateChannelMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the settings of a dataset.
     */
    override suspend fun updateDataset(input: UpdateDatasetRequest): UpdateDatasetResponse {
        val op = SdkHttpOperation.build<UpdateDatasetRequest, UpdateDatasetResponse> {
            serializer = UpdateDatasetOperationSerializer()
            deserializer = UpdateDatasetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDataset"
            }
        }
        registerUpdateDatasetMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Used to update the settings of a data store.
     */
    override suspend fun updateDatastore(input: UpdateDatastoreRequest): UpdateDatastoreResponse {
        val op = SdkHttpOperation.build<UpdateDatastoreRequest, UpdateDatastoreResponse> {
            serializer = UpdateDatastoreOperationSerializer()
            deserializer = UpdateDatastoreOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDatastore"
            }
        }
        registerUpdateDatastoreMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the settings of a pipeline. You must specify both a channel and a
     * datastore activity and, optionally, as many as 23 additional activities in the
     * pipelineActivities array.
     */
    override suspend fun updatePipeline(input: UpdatePipelineRequest): UpdatePipelineResponse {
        val op = SdkHttpOperation.build<UpdatePipelineRequest, UpdatePipelineResponse> {
            serializer = UpdatePipelineOperationSerializer()
            deserializer = UpdatePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePipeline"
            }
        }
        registerUpdatePipelineMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        val region = resolveRegionForOperation(ctx, config)
        ctx.putIfAbsent(AwsClientOption.Region, region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.signingRegion ?: region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
