// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An activity that runs a Lambda function to modify the message.
 */
public class LambdaActivity private constructor(builder: Builder) {
    /**
     * The number of messages passed to the Lambda function for processing.
     *
     * The Lambda function must be able to process all of these messages within five minutes, which is the maximum timeout duration for Lambda functions.
     */
    public val batchSize: kotlin.Int = requireNotNull(builder.batchSize) { "A non-null value must be provided for batchSize" }
    /**
     * The name of the Lambda function that is run on the message.
     */
    public val lambdaName: kotlin.String = requireNotNull(builder.lambdaName) { "A non-null value must be provided for lambdaName" }
    /**
     * The name of the lambda activity.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The next activity in the pipeline.
     */
    public val next: kotlin.String? = builder.next

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotanalytics.model.LambdaActivity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaActivity(")
        append("batchSize=$batchSize,")
        append("lambdaName=$lambdaName,")
        append("name=$name,")
        append("next=$next")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchSize
        result = 31 * result + (lambdaName.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (next?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaActivity

        if (batchSize != other.batchSize) return false
        if (lambdaName != other.lambdaName) return false
        if (name != other.name) return false
        if (next != other.next) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotanalytics.model.LambdaActivity = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of messages passed to the Lambda function for processing.
         *
         * The Lambda function must be able to process all of these messages within five minutes, which is the maximum timeout duration for Lambda functions.
         */
        public var batchSize: kotlin.Int? = null
        /**
         * The name of the Lambda function that is run on the message.
         */
        public var lambdaName: kotlin.String? = null
        /**
         * The name of the lambda activity.
         */
        public var name: kotlin.String? = null
        /**
         * The next activity in the pipeline.
         */
        public var next: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotanalytics.model.LambdaActivity) : this() {
            this.batchSize = x.batchSize
            this.lambdaName = x.lambdaName
            this.name = x.name
            this.next = x.next
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotanalytics.model.LambdaActivity = LambdaActivity(this)

        internal fun correctErrors(): Builder {
            if (batchSize == null) batchSize = 0
            if (lambdaName == null) lambdaName = ""
            if (name == null) name = ""
            return this
        }
    }
}
