// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.serde

import aws.sdk.kotlin.services.iotanalytics.model.SampleChannelDataRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class SampleChannelDataOperationSerializer: HttpSerializer.NonStreaming<SampleChannelDataRequest> {
    override fun serialize(context: ExecutionContext, input: SampleChannelDataRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.channelName) { "channelName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("channels"))
                add(PercentEncoding.SmithyLabel.encode(input.channelName))
                add(PercentEncoding.Path.encode("sample"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.endTime != null) add("endTime", input.endTime.format(TimestampFormat.ISO_8601))
                if (input.maxMessages != null) add("maxMessages", input.maxMessages.toString())
                if (input.startTime != null) add("startTime", input.startTime.format(TimestampFormat.ISO_8601))
            }
        }

        return builder
    }
}
