// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of information about a data store.
 */
public class DatastoreSummary private constructor(builder: Builder) {
    /**
     * When the data store was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The name of the data store.
     */
    public val datastoreName: kotlin.String? = builder.datastoreName
    /**
     * Contains information about the partition dimensions in a data store.
     */
    public val datastorePartitions: aws.sdk.kotlin.services.iotanalytics.model.DatastorePartitions? = builder.datastorePartitions
    /**
     * Where data in a data store is stored.
     */
    public val datastoreStorage: aws.sdk.kotlin.services.iotanalytics.model.DatastoreStorageSummary? = builder.datastoreStorage
    /**
     * The file format of the data in the data store.
     */
    public val fileFormatType: aws.sdk.kotlin.services.iotanalytics.model.FileFormatType? = builder.fileFormatType
    /**
     * The last time when a new message arrived in the data store.
     *
     * IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the `lastMessageArrivalTime` value is an approximation.
     *
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     */
    public val lastMessageArrivalTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastMessageArrivalTime
    /**
     * The last time the data store was updated.
     */
    public val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTime
    /**
     * The status of the data store.
     */
    public val status: aws.sdk.kotlin.services.iotanalytics.model.DatastoreStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotanalytics.model.DatastoreSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatastoreSummary(")
        append("creationTime=$creationTime,")
        append("datastoreName=$datastoreName,")
        append("datastorePartitions=$datastorePartitions,")
        append("datastoreStorage=$datastoreStorage,")
        append("fileFormatType=$fileFormatType,")
        append("lastMessageArrivalTime=$lastMessageArrivalTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (datastoreName?.hashCode() ?: 0)
        result = 31 * result + (datastorePartitions?.hashCode() ?: 0)
        result = 31 * result + (datastoreStorage?.hashCode() ?: 0)
        result = 31 * result + (fileFormatType?.hashCode() ?: 0)
        result = 31 * result + (lastMessageArrivalTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatastoreSummary

        if (creationTime != other.creationTime) return false
        if (datastoreName != other.datastoreName) return false
        if (datastorePartitions != other.datastorePartitions) return false
        if (datastoreStorage != other.datastoreStorage) return false
        if (fileFormatType != other.fileFormatType) return false
        if (lastMessageArrivalTime != other.lastMessageArrivalTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotanalytics.model.DatastoreSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the data store was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the data store.
         */
        public var datastoreName: kotlin.String? = null
        /**
         * Contains information about the partition dimensions in a data store.
         */
        public var datastorePartitions: aws.sdk.kotlin.services.iotanalytics.model.DatastorePartitions? = null
        /**
         * Where data in a data store is stored.
         */
        public var datastoreStorage: aws.sdk.kotlin.services.iotanalytics.model.DatastoreStorageSummary? = null
        /**
         * The file format of the data in the data store.
         */
        public var fileFormatType: aws.sdk.kotlin.services.iotanalytics.model.FileFormatType? = null
        /**
         * The last time when a new message arrived in the data store.
         *
         * IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the `lastMessageArrivalTime` value is an approximation.
         *
         * This feature only applies to messages that arrived in the data store after October 23, 2020.
         */
        public var lastMessageArrivalTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last time the data store was updated.
         */
        public var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the data store.
         */
        public var status: aws.sdk.kotlin.services.iotanalytics.model.DatastoreStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotanalytics.model.DatastoreSummary) : this() {
            this.creationTime = x.creationTime
            this.datastoreName = x.datastoreName
            this.datastorePartitions = x.datastorePartitions
            this.datastoreStorage = x.datastoreStorage
            this.fileFormatType = x.fileFormatType
            this.lastMessageArrivalTime = x.lastMessageArrivalTime
            this.lastUpdateTime = x.lastUpdateTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotanalytics.model.DatastoreSummary = DatastoreSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.DatastorePartitions] inside the given [block]
         */
        public fun datastorePartitions(block: aws.sdk.kotlin.services.iotanalytics.model.DatastorePartitions.Builder.() -> kotlin.Unit) {
            this.datastorePartitions = aws.sdk.kotlin.services.iotanalytics.model.DatastorePartitions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.DatastoreStorageSummary] inside the given [block]
         */
        public fun datastoreStorage(block: aws.sdk.kotlin.services.iotanalytics.model.DatastoreStorageSummary.Builder.() -> kotlin.Unit) {
            this.datastoreStorage = aws.sdk.kotlin.services.iotanalytics.model.DatastoreStorageSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
