// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.serde

import aws.sdk.kotlin.services.iotanalytics.model.IotAnalyticsException
import aws.sdk.kotlin.services.iotanalytics.model.RunPipelineActivityResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.decodeBase64Bytes
import kotlin.collections.mutableListOf


internal class RunPipelineActivityOperationDeserializer: HttpDeserializer.NonStreaming<RunPipelineActivityResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): RunPipelineActivityResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRunPipelineActivityError(context, call, payload)
        }
        val builder = RunPipelineActivityResponse.Builder()

        if (payload != null) {
            deserializeRunPipelineActivityOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwRunPipelineActivityError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotAnalyticsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> IotAnalyticsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRunPipelineActivityOperationBody(builder: RunPipelineActivityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LOGRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("logResult"))
    val PAYLOADS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("payloads"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LOGRESULT_DESCRIPTOR)
        field(PAYLOADS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LOGRESULT_DESCRIPTOR.index -> builder.logResult = deserializeString()
                PAYLOADS_DESCRIPTOR.index -> builder.payloads =
                    deserializer.deserializeList(PAYLOADS_DESCRIPTOR) {
                        val col0 = mutableListOf<ByteArray>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().decodeBase64Bytes() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
