// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An activity that computes an arithmetic expression using the message's attributes.
 */
public class MathActivity private constructor(builder: Builder) {
    /**
     * The name of the attribute that contains the result of the math operation.
     */
    public val attribute: kotlin.String = requireNotNull(builder.attribute) { "A non-null value must be provided for attribute" }
    /**
     * An expression that uses one or more existing attributes and must return an integer value.
     */
    public val math: kotlin.String = requireNotNull(builder.math) { "A non-null value must be provided for math" }
    /**
     * The name of the math activity.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The next activity in the pipeline.
     */
    public val next: kotlin.String? = builder.next

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotanalytics.model.MathActivity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MathActivity(")
        append("attribute=$attribute,")
        append("math=$math,")
        append("name=$name,")
        append("next=$next")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attribute.hashCode()
        result = 31 * result + (math.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (next?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MathActivity

        if (attribute != other.attribute) return false
        if (math != other.math) return false
        if (name != other.name) return false
        if (next != other.next) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotanalytics.model.MathActivity = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the attribute that contains the result of the math operation.
         */
        public var attribute: kotlin.String? = null
        /**
         * An expression that uses one or more existing attributes and must return an integer value.
         */
        public var math: kotlin.String? = null
        /**
         * The name of the math activity.
         */
        public var name: kotlin.String? = null
        /**
         * The next activity in the pipeline.
         */
        public var next: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotanalytics.model.MathActivity) : this() {
            this.attribute = x.attribute
            this.math = x.math
            this.name = x.name
            this.next = x.next
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotanalytics.model.MathActivity = MathActivity(this)

        internal fun correctErrors(): Builder {
            if (attribute == null) attribute = ""
            if (math == null) math = ""
            if (name == null) name = ""
            return this
        }
    }
}
