// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.serde

import aws.sdk.kotlin.services.iotanalytics.model.ListDatasetContentsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListDatasetContentsOperationSerializer: HttpSerializer.NonStreaming<ListDatasetContentsRequest> {
    override fun serialize(context: ExecutionContext, input: ListDatasetContentsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.datasetName) { "datasetName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("datasets"))
                add(PercentEncoding.SmithyLabel.encode("${input.datasetName}"))
                add(PercentEncoding.Path.encode("contents"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.maxResults != null) add("maxResults", "${input.maxResults}")
                if (input.nextToken != null) add("nextToken", input.nextToken)
                if (input.scheduledBefore != null) add("scheduledBefore", input.scheduledBefore.format(TimestampFormat.ISO_8601))
                if (input.scheduledOnOrAfter != null) add("scheduledOnOrAfter", input.scheduledOnOrAfter.format(TimestampFormat.ISO_8601))
            }
        }

        return builder
    }
}
