// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model

import aws.smithy.kotlin.runtime.time.Instant

public class ListDatasetContentsRequest private constructor(builder: Builder) {
    /**
     * The name of the dataset whose contents information you want to list.
     */
    public val datasetName: kotlin.String? = builder.datasetName
    /**
     * The maximum number of results to return in this request.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * A filter to limit results to those dataset contents whose creation is scheduled before the given time. See the field `triggers.schedule` in the `CreateDataset` request. (timestamp)
     */
    public val scheduledBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduledBefore
    /**
     * A filter to limit results to those dataset contents whose creation is scheduled on or after the given time. See the field `triggers.schedule` in the `CreateDataset` request. (timestamp)
     */
    public val scheduledOnOrAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduledOnOrAfter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotanalytics.model.ListDatasetContentsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDatasetContentsRequest(")
        append("datasetName=$datasetName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("scheduledBefore=$scheduledBefore,")
        append("scheduledOnOrAfter=$scheduledOnOrAfter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = datasetName?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (scheduledBefore?.hashCode() ?: 0)
        result = 31 * result + (scheduledOnOrAfter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDatasetContentsRequest

        if (datasetName != other.datasetName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (scheduledBefore != other.scheduledBefore) return false
        if (scheduledOnOrAfter != other.scheduledOnOrAfter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotanalytics.model.ListDatasetContentsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the dataset whose contents information you want to list.
         */
        public var datasetName: kotlin.String? = null
        /**
         * The maximum number of results to return in this request.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * A filter to limit results to those dataset contents whose creation is scheduled before the given time. See the field `triggers.schedule` in the `CreateDataset` request. (timestamp)
         */
        public var scheduledBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A filter to limit results to those dataset contents whose creation is scheduled on or after the given time. See the field `triggers.schedule` in the `CreateDataset` request. (timestamp)
         */
        public var scheduledOnOrAfter: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotanalytics.model.ListDatasetContentsRequest) : this() {
            this.datasetName = x.datasetName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.scheduledBefore = x.scheduledBefore
            this.scheduledOnOrAfter = x.scheduledOnOrAfter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotanalytics.model.ListDatasetContentsRequest = ListDatasetContentsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
