// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



/**
 * An activity that adds information from the IoT Device Shadow service to a message.
 */
public class DeviceShadowEnrichActivity private constructor(builder: Builder) {
    /**
     * The name of the attribute that is added to the message.
     */
    public val attribute: kotlin.String = requireNotNull(builder.attribute) { "A non-null value must be provided for attribute" }
    /**
     * The name of the `deviceShadowEnrich` activity.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The next activity in the pipeline.
     */
    public val next: kotlin.String? = builder.next
    /**
     * The ARN of the role that allows access to the device's shadow.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The name of the IoT device whose shadow information is added to the message.
     */
    public val thingName: kotlin.String = requireNotNull(builder.thingName) { "A non-null value must be provided for thingName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotanalytics.model.DeviceShadowEnrichActivity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeviceShadowEnrichActivity(")
        append("attribute=$attribute,")
        append("name=$name,")
        append("next=$next,")
        append("roleArn=$roleArn,")
        append("thingName=$thingName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attribute.hashCode()
        result = 31 * result + (name.hashCode())
        result = 31 * result + (next?.hashCode() ?: 0)
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (thingName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeviceShadowEnrichActivity

        if (attribute != other.attribute) return false
        if (name != other.name) return false
        if (next != other.next) return false
        if (roleArn != other.roleArn) return false
        if (thingName != other.thingName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotanalytics.model.DeviceShadowEnrichActivity = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the attribute that is added to the message.
         */
        public var attribute: kotlin.String? = null
        /**
         * The name of the `deviceShadowEnrich` activity.
         */
        public var name: kotlin.String? = null
        /**
         * The next activity in the pipeline.
         */
        public var next: kotlin.String? = null
        /**
         * The ARN of the role that allows access to the device's shadow.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The name of the IoT device whose shadow information is added to the message.
         */
        public var thingName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotanalytics.model.DeviceShadowEnrichActivity) : this() {
            this.attribute = x.attribute
            this.name = x.name
            this.next = x.next
            this.roleArn = x.roleArn
            this.thingName = x.thingName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotanalytics.model.DeviceShadowEnrichActivity = DeviceShadowEnrichActivity(this)

        internal fun correctErrors(): Builder {
            if (attribute == null) attribute = ""
            if (name == null) name = ""
            if (roleArn == null) roleArn = ""
            if (thingName == null) thingName = ""
            return this
        }
    }
}
