// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.serde

import aws.sdk.kotlin.services.iotanalytics.model.DatastoreStorage
import aws.sdk.kotlin.services.iotanalytics.model.FileFormatConfiguration
import aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod
import aws.sdk.kotlin.services.iotanalytics.model.UpdateDatastoreRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateDatastoreOperationSerializer: HttpSerialize<UpdateDatastoreRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateDatastoreRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.datastoreName) { "datastoreName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("datastores"))
                add(PercentEncoding.SmithyLabel.encode("${input.datastoreName}"))
            }
        }

        val payload = serializeUpdateDatastoreOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateDatastoreOperationBody(context: ExecutionContext, input: UpdateDatastoreRequest): ByteArray {
    val serializer = JsonSerializer()
    val DATASTORESTORAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("datastoreStorage"))
    val FILEFORMATCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("fileFormatConfiguration"))
    val RETENTIONPERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("retentionPeriod"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATASTORESTORAGE_DESCRIPTOR)
        field(FILEFORMATCONFIGURATION_DESCRIPTOR)
        field(RETENTIONPERIOD_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.datastoreStorage?.let { field(DATASTORESTORAGE_DESCRIPTOR, it, ::serializeDatastoreStorageDocument) }
        input.fileFormatConfiguration?.let { field(FILEFORMATCONFIGURATION_DESCRIPTOR, it, ::serializeFileFormatConfigurationDocument) }
        input.retentionPeriod?.let { field(RETENTIONPERIOD_DESCRIPTOR, it, ::serializeRetentionPeriodDocument) }
    }
    return serializer.toByteArray()
}
