// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.transform

import aws.sdk.kotlin.services.iotanalytics.model.IoTAnalyticsException
import aws.sdk.kotlin.services.iotanalytics.model.RunPipelineActivityResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.util.decodeBase64Bytes
import kotlin.collections.mutableListOf


internal class RunPipelineActivityOperationDeserializer: HttpDeserialize<RunPipelineActivityResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RunPipelineActivityResponse {
        if (!response.status.isSuccess()) {
            throwRunPipelineActivityError(context, response)
        }
        val builder = RunPipelineActivityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRunPipelineActivityOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRunPipelineActivityError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTAnalyticsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTAnalyticsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRunPipelineActivityOperationBody(builder: RunPipelineActivityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LOGRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("logResult"))
    val PAYLOADS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("payloads"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LOGRESULT_DESCRIPTOR)
        field(PAYLOADS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LOGRESULT_DESCRIPTOR.index -> builder.logResult = deserializeString()
                PAYLOADS_DESCRIPTOR.index -> builder.payloads =
                    deserializer.deserializeList(PAYLOADS_DESCRIPTOR) {
                        val col0 = mutableListOf<ByteArray>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().decodeBase64Bytes() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
