// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.transform

import aws.sdk.kotlin.services.iotanalytics.model.ListDatasetContentsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.net.parameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListDatasetContentsOperationSerializer: HttpSerialize<ListDatasetContentsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListDatasetContentsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            val pathSegments = listOf<String>(
                "datasets",
                "${input.datasetName}".encodeLabel(),
                "contents",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.maxResults != null) append("maxResults", "${input.maxResults}")
                if (input.nextToken != null) append("nextToken", input.nextToken)
                if (input.scheduledBefore != null) append("scheduledBefore", input.scheduledBefore.format(TimestampFormat.ISO_8601))
                if (input.scheduledOnOrAfter != null) append("scheduledOnOrAfter", input.scheduledOnOrAfter.format(TimestampFormat.ISO_8601))
            }
        }

        return builder
    }
}
