// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.transform

import aws.sdk.kotlin.services.iotanalytics.model.DescribeLoggingOptionsResponse
import aws.sdk.kotlin.services.iotanalytics.model.IoTAnalyticsException
import aws.sdk.kotlin.services.iotanalytics.model.LoggingOptions
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeLoggingOptionsOperationDeserializer: HttpDeserialize<DescribeLoggingOptionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeLoggingOptionsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeLoggingOptionsError(context, response)
        }
        val builder = DescribeLoggingOptionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeLoggingOptionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeLoggingOptionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTAnalyticsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTAnalyticsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeLoggingOptionsOperationBody(builder: DescribeLoggingOptionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LOGGINGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("loggingOptions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LOGGINGOPTIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LOGGINGOPTIONS_DESCRIPTOR.index -> builder.loggingOptions = deserializeLoggingOptionsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
