// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.paginators

import aws.sdk.kotlin.services.iotanalytics.IoTAnalyticsClient
import aws.sdk.kotlin.services.iotanalytics.model.ListChannelsRequest
import aws.sdk.kotlin.services.iotanalytics.model.ListChannelsResponse
import aws.sdk.kotlin.services.iotanalytics.model.ListDatasetContentsRequest
import aws.sdk.kotlin.services.iotanalytics.model.ListDatasetContentsResponse
import aws.sdk.kotlin.services.iotanalytics.model.ListDatasetsRequest
import aws.sdk.kotlin.services.iotanalytics.model.ListDatasetsResponse
import aws.sdk.kotlin.services.iotanalytics.model.ListDatastoresRequest
import aws.sdk.kotlin.services.iotanalytics.model.ListDatastoresResponse
import aws.sdk.kotlin.services.iotanalytics.model.ListPipelinesRequest
import aws.sdk.kotlin.services.iotanalytics.model.ListPipelinesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChannelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsResponse]
 */
public fun IoTAnalyticsClient.listChannelsPaginated(initialRequest: ListChannelsRequest): Flow<ListChannelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChannelsPaginated.listChannels(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChannelsResponse]
 */
public fun IoTAnalyticsClient.listChannelsPaginated(block: ListChannelsRequest.Builder.() -> Unit): Flow<ListChannelsResponse> =
    listChannelsPaginated(ListChannelsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDatasetContentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetContentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetContentsResponse]
 */
public fun IoTAnalyticsClient.listDatasetContentsPaginated(initialRequest: ListDatasetContentsRequest): Flow<ListDatasetContentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetContentsPaginated.listDatasetContents(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetContentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetContentsResponse]
 */
public fun IoTAnalyticsClient.listDatasetContentsPaginated(block: ListDatasetContentsRequest.Builder.() -> Unit): Flow<ListDatasetContentsResponse> =
    listDatasetContentsPaginated(ListDatasetContentsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDatasetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetsResponse]
 */
public fun IoTAnalyticsClient.listDatasetsPaginated(initialRequest: ListDatasetsRequest): Flow<ListDatasetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetsPaginated.listDatasets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetsResponse]
 */
public fun IoTAnalyticsClient.listDatasetsPaginated(block: ListDatasetsRequest.Builder.() -> Unit): Flow<ListDatasetsResponse> =
    listDatasetsPaginated(ListDatasetsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDatastoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatastoresRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatastoresResponse]
 */
public fun IoTAnalyticsClient.listDatastoresPaginated(initialRequest: ListDatastoresRequest): Flow<ListDatastoresResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatastoresPaginated.listDatastores(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDatastoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatastoresResponse]
 */
public fun IoTAnalyticsClient.listDatastoresPaginated(block: ListDatastoresRequest.Builder.() -> Unit): Flow<ListDatastoresResponse> =
    listDatastoresPaginated(ListDatastoresRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPipelinesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPipelinesResponse]
 */
public fun IoTAnalyticsClient.listPipelinesPaginated(initialRequest: ListPipelinesRequest): Flow<ListPipelinesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPipelinesPaginated.listPipelines(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPipelinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPipelinesResponse]
 */
public fun IoTAnalyticsClient.listPipelinesPaginated(block: ListPipelinesRequest.Builder.() -> Unit): Flow<ListPipelinesResponse> =
    listPipelinesPaginated(ListPipelinesRequest.Builder().apply(block).build())
