// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



/**
 * A `DatasetAction` object that specifies how dataset contents are automatically created.
 */
public class DatasetAction private constructor(builder: Builder) {
    /**
     * The name of the dataset action by which dataset contents are automatically created.
     */
    public val actionName: kotlin.String? = builder.actionName
    /**
     * Information that allows the system to run a containerized application to create the dataset contents. The application must be in a Docker container along with any required support libraries.
     */
    public val containerAction: aws.sdk.kotlin.services.iotanalytics.model.ContainerDatasetAction? = builder.containerAction
    /**
     * An `SqlQueryDatasetAction` object that uses an SQL query to automatically create dataset contents.
     */
    public val queryAction: aws.sdk.kotlin.services.iotanalytics.model.SqlQueryDatasetAction? = builder.queryAction

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotanalytics.model.DatasetAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetAction(")
        append("actionName=$actionName,")
        append("containerAction=$containerAction,")
        append("queryAction=$queryAction")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionName?.hashCode() ?: 0
        result = 31 * result + (containerAction?.hashCode() ?: 0)
        result = 31 * result + (queryAction?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetAction

        if (actionName != other.actionName) return false
        if (containerAction != other.containerAction) return false
        if (queryAction != other.queryAction) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotanalytics.model.DatasetAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the dataset action by which dataset contents are automatically created.
         */
        public var actionName: kotlin.String? = null
        /**
         * Information that allows the system to run a containerized application to create the dataset contents. The application must be in a Docker container along with any required support libraries.
         */
        public var containerAction: aws.sdk.kotlin.services.iotanalytics.model.ContainerDatasetAction? = null
        /**
         * An `SqlQueryDatasetAction` object that uses an SQL query to automatically create dataset contents.
         */
        public var queryAction: aws.sdk.kotlin.services.iotanalytics.model.SqlQueryDatasetAction? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotanalytics.model.DatasetAction) : this() {
            this.actionName = x.actionName
            this.containerAction = x.containerAction
            this.queryAction = x.queryAction
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotanalytics.model.DatasetAction = DatasetAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.ContainerDatasetAction] inside the given [block]
         */
        public fun containerAction(block: aws.sdk.kotlin.services.iotanalytics.model.ContainerDatasetAction.Builder.() -> kotlin.Unit) {
            this.containerAction = aws.sdk.kotlin.services.iotanalytics.model.ContainerDatasetAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.SqlQueryDatasetAction] inside the given [block]
         */
        public fun queryAction(block: aws.sdk.kotlin.services.iotanalytics.model.SqlQueryDatasetAction.Builder.() -> kotlin.Unit) {
            this.queryAction = aws.sdk.kotlin.services.iotanalytics.model.SqlQueryDatasetAction.invoke(block)
        }
    }
}
