// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



public class CreateDatasetRequest private constructor(builder: Builder) {
    /**
     * A list of actions that create the dataset contents.
     */
    public val actions: List<DatasetAction>? = builder.actions
    /**
     * When dataset contents are created, they are delivered to destinations specified here.
     */
    public val contentDeliveryRules: List<DatasetContentDeliveryRule>? = builder.contentDeliveryRules
    /**
     * The name of the dataset.
     */
    public val datasetName: kotlin.String? = builder.datasetName
    /**
     * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify `lateDataRules`, the dataset must use a [DeltaTimer](https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html) filter.
     */
    public val lateDataRules: List<LateDataRule>? = builder.lateDataRules
    /**
     * Optional. How long, in days, versions of dataset contents are kept for the dataset. If not specified or set to `null`, versions of dataset contents are retained for at most 90 days. The number of versions of dataset contents retained is determined by the `versioningConfiguration` parameter. For more information, see [ Keeping Multiple Versions of IoT Analytics datasets](https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions) in the *IoT Analytics User Guide*.
     */
    public val retentionPeriod: aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod? = builder.retentionPeriod
    /**
     * Metadata which can be used to manage the dataset.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A list of triggers. A trigger causes dataset contents to be populated at a specified time interval or when another dataset's contents are created. The list of triggers can be empty or contain up to five `DataSetTrigger` objects.
     */
    public val triggers: List<DatasetTrigger>? = builder.triggers
    /**
     * Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the `retentionPeriod` parameter. For more information, see [Keeping Multiple Versions of IoT Analytics datasets](https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions) in the *IoT Analytics User Guide*.
     */
    public val versioningConfiguration: aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration? = builder.versioningConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotanalytics.model.CreateDatasetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDatasetRequest(")
        append("actions=$actions,")
        append("contentDeliveryRules=$contentDeliveryRules,")
        append("datasetName=$datasetName,")
        append("lateDataRules=$lateDataRules,")
        append("retentionPeriod=$retentionPeriod,")
        append("tags=$tags,")
        append("triggers=$triggers,")
        append("versioningConfiguration=$versioningConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (contentDeliveryRules?.hashCode() ?: 0)
        result = 31 * result + (datasetName?.hashCode() ?: 0)
        result = 31 * result + (lateDataRules?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (triggers?.hashCode() ?: 0)
        result = 31 * result + (versioningConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDatasetRequest

        if (actions != other.actions) return false
        if (contentDeliveryRules != other.contentDeliveryRules) return false
        if (datasetName != other.datasetName) return false
        if (lateDataRules != other.lateDataRules) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (tags != other.tags) return false
        if (triggers != other.triggers) return false
        if (versioningConfiguration != other.versioningConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotanalytics.model.CreateDatasetRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of actions that create the dataset contents.
         */
        public var actions: List<DatasetAction>? = null
        /**
         * When dataset contents are created, they are delivered to destinations specified here.
         */
        public var contentDeliveryRules: List<DatasetContentDeliveryRule>? = null
        /**
         * The name of the dataset.
         */
        public var datasetName: kotlin.String? = null
        /**
         * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify `lateDataRules`, the dataset must use a [DeltaTimer](https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html) filter.
         */
        public var lateDataRules: List<LateDataRule>? = null
        /**
         * Optional. How long, in days, versions of dataset contents are kept for the dataset. If not specified or set to `null`, versions of dataset contents are retained for at most 90 days. The number of versions of dataset contents retained is determined by the `versioningConfiguration` parameter. For more information, see [ Keeping Multiple Versions of IoT Analytics datasets](https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions) in the *IoT Analytics User Guide*.
         */
        public var retentionPeriod: aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod? = null
        /**
         * Metadata which can be used to manage the dataset.
         */
        public var tags: List<Tag>? = null
        /**
         * A list of triggers. A trigger causes dataset contents to be populated at a specified time interval or when another dataset's contents are created. The list of triggers can be empty or contain up to five `DataSetTrigger` objects.
         */
        public var triggers: List<DatasetTrigger>? = null
        /**
         * Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the `retentionPeriod` parameter. For more information, see [Keeping Multiple Versions of IoT Analytics datasets](https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions) in the *IoT Analytics User Guide*.
         */
        public var versioningConfiguration: aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotanalytics.model.CreateDatasetRequest) : this() {
            this.actions = x.actions
            this.contentDeliveryRules = x.contentDeliveryRules
            this.datasetName = x.datasetName
            this.lateDataRules = x.lateDataRules
            this.retentionPeriod = x.retentionPeriod
            this.tags = x.tags
            this.triggers = x.triggers
            this.versioningConfiguration = x.versioningConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotanalytics.model.CreateDatasetRequest = CreateDatasetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod] inside the given [block]
         */
        public fun retentionPeriod(block: aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod.Builder.() -> kotlin.Unit) {
            this.retentionPeriod = aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration] inside the given [block]
         */
        public fun versioningConfiguration(block: aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration.Builder.() -> kotlin.Unit) {
            this.versioningConfiguration = aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration.invoke(block)
        }
    }
}
