// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.iotanalytics.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.iotanalytics.endpoints.EndpointProvider
import aws.sdk.kotlin.services.iotanalytics.model.BatchPutMessageRequest
import aws.sdk.kotlin.services.iotanalytics.model.BatchPutMessageResponse
import aws.sdk.kotlin.services.iotanalytics.model.CancelPipelineReprocessingRequest
import aws.sdk.kotlin.services.iotanalytics.model.CancelPipelineReprocessingResponse
import aws.sdk.kotlin.services.iotanalytics.model.CreateChannelRequest
import aws.sdk.kotlin.services.iotanalytics.model.CreateChannelResponse
import aws.sdk.kotlin.services.iotanalytics.model.CreateDatasetContentRequest
import aws.sdk.kotlin.services.iotanalytics.model.CreateDatasetContentResponse
import aws.sdk.kotlin.services.iotanalytics.model.CreateDatasetRequest
import aws.sdk.kotlin.services.iotanalytics.model.CreateDatasetResponse
import aws.sdk.kotlin.services.iotanalytics.model.CreateDatastoreRequest
import aws.sdk.kotlin.services.iotanalytics.model.CreateDatastoreResponse
import aws.sdk.kotlin.services.iotanalytics.model.CreatePipelineRequest
import aws.sdk.kotlin.services.iotanalytics.model.CreatePipelineResponse
import aws.sdk.kotlin.services.iotanalytics.model.DeleteChannelRequest
import aws.sdk.kotlin.services.iotanalytics.model.DeleteChannelResponse
import aws.sdk.kotlin.services.iotanalytics.model.DeleteDatasetContentRequest
import aws.sdk.kotlin.services.iotanalytics.model.DeleteDatasetContentResponse
import aws.sdk.kotlin.services.iotanalytics.model.DeleteDatasetRequest
import aws.sdk.kotlin.services.iotanalytics.model.DeleteDatasetResponse
import aws.sdk.kotlin.services.iotanalytics.model.DeleteDatastoreRequest
import aws.sdk.kotlin.services.iotanalytics.model.DeleteDatastoreResponse
import aws.sdk.kotlin.services.iotanalytics.model.DeletePipelineRequest
import aws.sdk.kotlin.services.iotanalytics.model.DeletePipelineResponse
import aws.sdk.kotlin.services.iotanalytics.model.DescribeChannelRequest
import aws.sdk.kotlin.services.iotanalytics.model.DescribeChannelResponse
import aws.sdk.kotlin.services.iotanalytics.model.DescribeDatasetRequest
import aws.sdk.kotlin.services.iotanalytics.model.DescribeDatasetResponse
import aws.sdk.kotlin.services.iotanalytics.model.DescribeDatastoreRequest
import aws.sdk.kotlin.services.iotanalytics.model.DescribeDatastoreResponse
import aws.sdk.kotlin.services.iotanalytics.model.DescribeLoggingOptionsRequest
import aws.sdk.kotlin.services.iotanalytics.model.DescribeLoggingOptionsResponse
import aws.sdk.kotlin.services.iotanalytics.model.DescribePipelineRequest
import aws.sdk.kotlin.services.iotanalytics.model.DescribePipelineResponse
import aws.sdk.kotlin.services.iotanalytics.model.GetDatasetContentRequest
import aws.sdk.kotlin.services.iotanalytics.model.GetDatasetContentResponse
import aws.sdk.kotlin.services.iotanalytics.model.ListChannelsRequest
import aws.sdk.kotlin.services.iotanalytics.model.ListChannelsResponse
import aws.sdk.kotlin.services.iotanalytics.model.ListDatasetContentsRequest
import aws.sdk.kotlin.services.iotanalytics.model.ListDatasetContentsResponse
import aws.sdk.kotlin.services.iotanalytics.model.ListDatasetsRequest
import aws.sdk.kotlin.services.iotanalytics.model.ListDatasetsResponse
import aws.sdk.kotlin.services.iotanalytics.model.ListDatastoresRequest
import aws.sdk.kotlin.services.iotanalytics.model.ListDatastoresResponse
import aws.sdk.kotlin.services.iotanalytics.model.ListPipelinesRequest
import aws.sdk.kotlin.services.iotanalytics.model.ListPipelinesResponse
import aws.sdk.kotlin.services.iotanalytics.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iotanalytics.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iotanalytics.model.PutLoggingOptionsRequest
import aws.sdk.kotlin.services.iotanalytics.model.PutLoggingOptionsResponse
import aws.sdk.kotlin.services.iotanalytics.model.RunPipelineActivityRequest
import aws.sdk.kotlin.services.iotanalytics.model.RunPipelineActivityResponse
import aws.sdk.kotlin.services.iotanalytics.model.SampleChannelDataRequest
import aws.sdk.kotlin.services.iotanalytics.model.SampleChannelDataResponse
import aws.sdk.kotlin.services.iotanalytics.model.StartPipelineReprocessingRequest
import aws.sdk.kotlin.services.iotanalytics.model.StartPipelineReprocessingResponse
import aws.sdk.kotlin.services.iotanalytics.model.TagResourceRequest
import aws.sdk.kotlin.services.iotanalytics.model.TagResourceResponse
import aws.sdk.kotlin.services.iotanalytics.model.UntagResourceRequest
import aws.sdk.kotlin.services.iotanalytics.model.UntagResourceResponse
import aws.sdk.kotlin.services.iotanalytics.model.UpdateChannelRequest
import aws.sdk.kotlin.services.iotanalytics.model.UpdateChannelResponse
import aws.sdk.kotlin.services.iotanalytics.model.UpdateDatasetRequest
import aws.sdk.kotlin.services.iotanalytics.model.UpdateDatasetResponse
import aws.sdk.kotlin.services.iotanalytics.model.UpdateDatastoreRequest
import aws.sdk.kotlin.services.iotanalytics.model.UpdateDatastoreResponse
import aws.sdk.kotlin.services.iotanalytics.model.UpdatePipelineRequest
import aws.sdk.kotlin.services.iotanalytics.model.UpdatePipelineResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * IoT Analytics allows you to collect large amounts of device data, process messages, and store them. You can then query the data and run sophisticated analytics on it. IoT Analytics enables advanced data exploration through integration with Jupyter Notebooks and data visualization through integration with Amazon QuickSight.
 *
 * Traditional analytics and business intelligence tools are designed to process structured data. IoT data often comes from devices that record noisy processes (such as temperature, motion, or sound). As a result the data from these devices can have significant gaps, corrupted messages, and false readings that must be cleaned up before analysis can occur. Also, IoT data is often only meaningful in the context of other data from external sources.
 *
 * IoT Analytics automates the steps required to analyze data from IoT devices. IoT Analytics filters, transforms, and enriches IoT data before storing it in a time-series data store for analysis. You can set up the service to collect only the data you need from your devices, apply mathematical transforms to process the data, and enrich the data with device-specific metadata such as device type and location before storing it. Then, you can analyze your data by running queries using the built-in SQL query engine, or perform more complex analytics and machine learning inference. IoT Analytics includes pre-built models for common IoT use cases so you can answer questions like which devices are about to fail or which customers are at risk of abandoning their wearable devices.
 */
public interface IoTAnalyticsClient : SdkClient {
    /**
     * IoTAnalyticsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, IoTAnalyticsClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, IoTAnalyticsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): IoTAnalyticsClient = DefaultIoTAnalyticsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val clientName: String = builder.clientName
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, clientName)
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            interceptors = this@Config.interceptors.toMutableList()
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            sdkLogMode = this@Config.sdkLogMode
            signer = this@Config.signer
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, HttpClientConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "IoTAnalytics"

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Sends messages to a channel.
     */
    public suspend fun batchPutMessage(input: BatchPutMessageRequest): BatchPutMessageResponse

    /**
     * Cancels the reprocessing of data through the pipeline.
     */
    public suspend fun cancelPipelineReprocessing(input: CancelPipelineReprocessingRequest): CancelPipelineReprocessingResponse

    /**
     * Used to create a channel. A channel collects data from an MQTT topic and archives the raw, unprocessed messages before publishing the data to a pipeline.
     */
    public suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse

    /**
     * Used to create a dataset. A dataset stores data retrieved from a data store by applying a `queryAction` (a SQL query) or a `containerAction` (executing a containerized application). This operation creates the skeleton of a dataset. The dataset can be populated manually by calling `CreateDatasetContent` or automatically according to a trigger you specify.
     */
    public suspend fun createDataset(input: CreateDatasetRequest): CreateDatasetResponse

    /**
     * Creates the content of a dataset by applying a `queryAction` (a SQL query) or a `containerAction` (executing a containerized application).
     */
    public suspend fun createDatasetContent(input: CreateDatasetContentRequest): CreateDatasetContentResponse

    /**
     * Creates a data store, which is a repository for messages.
     */
    public suspend fun createDatastore(input: CreateDatastoreRequest): CreateDatastoreResponse

    /**
     * Creates a pipeline. A pipeline consumes messages from a channel and allows you to process the messages before storing them in a data store. You must specify both a `channel` and a `datastore` activity and, optionally, as many as 23 additional activities in the `pipelineActivities` array.
     */
    public suspend fun createPipeline(input: CreatePipelineRequest): CreatePipelineResponse

    /**
     * Deletes the specified channel.
     */
    public suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * Deletes the specified dataset.
     *
     * You do not have to delete the content of the dataset before you perform this operation.
     */
    public suspend fun deleteDataset(input: DeleteDatasetRequest): DeleteDatasetResponse

    /**
     * Deletes the content of the specified dataset.
     */
    public suspend fun deleteDatasetContent(input: DeleteDatasetContentRequest): DeleteDatasetContentResponse

    /**
     * Deletes the specified data store.
     */
    public suspend fun deleteDatastore(input: DeleteDatastoreRequest): DeleteDatastoreResponse

    /**
     * Deletes the specified pipeline.
     */
    public suspend fun deletePipeline(input: DeletePipelineRequest): DeletePipelineResponse

    /**
     * Retrieves information about a channel.
     */
    public suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse

    /**
     * Retrieves information about a dataset.
     */
    public suspend fun describeDataset(input: DescribeDatasetRequest): DescribeDatasetResponse

    /**
     * Retrieves information about a data store.
     */
    public suspend fun describeDatastore(input: DescribeDatastoreRequest): DescribeDatastoreResponse

    /**
     * Retrieves the current settings of the IoT Analytics logging options.
     */
    public suspend fun describeLoggingOptions(input: DescribeLoggingOptionsRequest = DescribeLoggingOptionsRequest {}): DescribeLoggingOptionsResponse

    /**
     * Retrieves information about a pipeline.
     */
    public suspend fun describePipeline(input: DescribePipelineRequest): DescribePipelineResponse

    /**
     * Retrieves the contents of a dataset as presigned URIs.
     */
    public suspend fun getDatasetContent(input: GetDatasetContentRequest): GetDatasetContentResponse

    /**
     * Retrieves a list of channels.
     */
    public suspend fun listChannels(input: ListChannelsRequest = ListChannelsRequest {}): ListChannelsResponse

    /**
     * Lists information about dataset contents that have been created.
     */
    public suspend fun listDatasetContents(input: ListDatasetContentsRequest): ListDatasetContentsResponse

    /**
     * Retrieves information about datasets.
     */
    public suspend fun listDatasets(input: ListDatasetsRequest = ListDatasetsRequest {}): ListDatasetsResponse

    /**
     * Retrieves a list of data stores.
     */
    public suspend fun listDatastores(input: ListDatastoresRequest = ListDatastoresRequest {}): ListDatastoresResponse

    /**
     * Retrieves a list of pipelines.
     */
    public suspend fun listPipelines(input: ListPipelinesRequest = ListPipelinesRequest {}): ListPipelinesResponse

    /**
     * Lists the tags (metadata) that you have assigned to the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Sets or updates the IoT Analytics logging options.
     *
     * If you update the value of any `loggingOptions` field, it takes up to one minute for the change to take effect. Also, if you change the policy attached to the role you specified in the `roleArn` field (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect.
     */
    public suspend fun putLoggingOptions(input: PutLoggingOptionsRequest): PutLoggingOptionsResponse

    /**
     * Simulates the results of running a pipeline activity on a message payload.
     */
    public suspend fun runPipelineActivity(input: RunPipelineActivityRequest): RunPipelineActivityResponse

    /**
     * Retrieves a sample of messages from the specified channel ingested during the specified timeframe. Up to 10 messages can be retrieved.
     */
    public suspend fun sampleChannelData(input: SampleChannelDataRequest): SampleChannelDataResponse

    /**
     * Starts the reprocessing of raw message data through the pipeline.
     */
    public suspend fun startPipelineReprocessing(input: StartPipelineReprocessingRequest): StartPipelineReprocessingResponse

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the given tags (metadata) from the resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Used to update the settings of a channel.
     */
    public suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse

    /**
     * Updates the settings of a dataset.
     */
    public suspend fun updateDataset(input: UpdateDatasetRequest): UpdateDatasetResponse

    /**
     * Used to update the settings of a data store.
     */
    public suspend fun updateDatastore(input: UpdateDatastoreRequest): UpdateDatastoreResponse

    /**
     * Updates the settings of a pipeline. You must specify both a `channel` and a `datastore` activity and, optionally, as many as 23 additional activities in the `pipelineActivities` array.
     */
    public suspend fun updatePipeline(input: UpdatePipelineRequest): UpdatePipelineResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun IoTAnalyticsClient.withConfig(block: IoTAnalyticsClient.Config.Builder.() -> Unit): IoTAnalyticsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIoTAnalyticsClient(newConfig)
}

/**
 * Sends messages to a channel.
 */
public suspend inline fun IoTAnalyticsClient.batchPutMessage(crossinline block: BatchPutMessageRequest.Builder.() -> Unit): BatchPutMessageResponse = batchPutMessage(BatchPutMessageRequest.Builder().apply(block).build())

/**
 * Cancels the reprocessing of data through the pipeline.
 */
public suspend inline fun IoTAnalyticsClient.cancelPipelineReprocessing(crossinline block: CancelPipelineReprocessingRequest.Builder.() -> Unit): CancelPipelineReprocessingResponse = cancelPipelineReprocessing(CancelPipelineReprocessingRequest.Builder().apply(block).build())

/**
 * Used to create a channel. A channel collects data from an MQTT topic and archives the raw, unprocessed messages before publishing the data to a pipeline.
 */
public suspend inline fun IoTAnalyticsClient.createChannel(crossinline block: CreateChannelRequest.Builder.() -> Unit): CreateChannelResponse = createChannel(CreateChannelRequest.Builder().apply(block).build())

/**
 * Used to create a dataset. A dataset stores data retrieved from a data store by applying a `queryAction` (a SQL query) or a `containerAction` (executing a containerized application). This operation creates the skeleton of a dataset. The dataset can be populated manually by calling `CreateDatasetContent` or automatically according to a trigger you specify.
 */
public suspend inline fun IoTAnalyticsClient.createDataset(crossinline block: CreateDatasetRequest.Builder.() -> Unit): CreateDatasetResponse = createDataset(CreateDatasetRequest.Builder().apply(block).build())

/**
 * Creates the content of a dataset by applying a `queryAction` (a SQL query) or a `containerAction` (executing a containerized application).
 */
public suspend inline fun IoTAnalyticsClient.createDatasetContent(crossinline block: CreateDatasetContentRequest.Builder.() -> Unit): CreateDatasetContentResponse = createDatasetContent(CreateDatasetContentRequest.Builder().apply(block).build())

/**
 * Creates a data store, which is a repository for messages.
 */
public suspend inline fun IoTAnalyticsClient.createDatastore(crossinline block: CreateDatastoreRequest.Builder.() -> Unit): CreateDatastoreResponse = createDatastore(CreateDatastoreRequest.Builder().apply(block).build())

/**
 * Creates a pipeline. A pipeline consumes messages from a channel and allows you to process the messages before storing them in a data store. You must specify both a `channel` and a `datastore` activity and, optionally, as many as 23 additional activities in the `pipelineActivities` array.
 */
public suspend inline fun IoTAnalyticsClient.createPipeline(crossinline block: CreatePipelineRequest.Builder.() -> Unit): CreatePipelineResponse = createPipeline(CreatePipelineRequest.Builder().apply(block).build())

/**
 * Deletes the specified channel.
 */
public suspend inline fun IoTAnalyticsClient.deleteChannel(crossinline block: DeleteChannelRequest.Builder.() -> Unit): DeleteChannelResponse = deleteChannel(DeleteChannelRequest.Builder().apply(block).build())

/**
 * Deletes the specified dataset.
 *
 * You do not have to delete the content of the dataset before you perform this operation.
 */
public suspend inline fun IoTAnalyticsClient.deleteDataset(crossinline block: DeleteDatasetRequest.Builder.() -> Unit): DeleteDatasetResponse = deleteDataset(DeleteDatasetRequest.Builder().apply(block).build())

/**
 * Deletes the content of the specified dataset.
 */
public suspend inline fun IoTAnalyticsClient.deleteDatasetContent(crossinline block: DeleteDatasetContentRequest.Builder.() -> Unit): DeleteDatasetContentResponse = deleteDatasetContent(DeleteDatasetContentRequest.Builder().apply(block).build())

/**
 * Deletes the specified data store.
 */
public suspend inline fun IoTAnalyticsClient.deleteDatastore(crossinline block: DeleteDatastoreRequest.Builder.() -> Unit): DeleteDatastoreResponse = deleteDatastore(DeleteDatastoreRequest.Builder().apply(block).build())

/**
 * Deletes the specified pipeline.
 */
public suspend inline fun IoTAnalyticsClient.deletePipeline(crossinline block: DeletePipelineRequest.Builder.() -> Unit): DeletePipelineResponse = deletePipeline(DeletePipelineRequest.Builder().apply(block).build())

/**
 * Retrieves information about a channel.
 */
public suspend inline fun IoTAnalyticsClient.describeChannel(crossinline block: DescribeChannelRequest.Builder.() -> Unit): DescribeChannelResponse = describeChannel(DescribeChannelRequest.Builder().apply(block).build())

/**
 * Retrieves information about a dataset.
 */
public suspend inline fun IoTAnalyticsClient.describeDataset(crossinline block: DescribeDatasetRequest.Builder.() -> Unit): DescribeDatasetResponse = describeDataset(DescribeDatasetRequest.Builder().apply(block).build())

/**
 * Retrieves information about a data store.
 */
public suspend inline fun IoTAnalyticsClient.describeDatastore(crossinline block: DescribeDatastoreRequest.Builder.() -> Unit): DescribeDatastoreResponse = describeDatastore(DescribeDatastoreRequest.Builder().apply(block).build())

/**
 * Retrieves the current settings of the IoT Analytics logging options.
 */
public suspend inline fun IoTAnalyticsClient.describeLoggingOptions(crossinline block: DescribeLoggingOptionsRequest.Builder.() -> Unit): DescribeLoggingOptionsResponse = describeLoggingOptions(DescribeLoggingOptionsRequest.Builder().apply(block).build())

/**
 * Retrieves information about a pipeline.
 */
public suspend inline fun IoTAnalyticsClient.describePipeline(crossinline block: DescribePipelineRequest.Builder.() -> Unit): DescribePipelineResponse = describePipeline(DescribePipelineRequest.Builder().apply(block).build())

/**
 * Retrieves the contents of a dataset as presigned URIs.
 */
public suspend inline fun IoTAnalyticsClient.getDatasetContent(crossinline block: GetDatasetContentRequest.Builder.() -> Unit): GetDatasetContentResponse = getDatasetContent(GetDatasetContentRequest.Builder().apply(block).build())

/**
 * Retrieves a list of channels.
 */
public suspend inline fun IoTAnalyticsClient.listChannels(crossinline block: ListChannelsRequest.Builder.() -> Unit): ListChannelsResponse = listChannels(ListChannelsRequest.Builder().apply(block).build())

/**
 * Lists information about dataset contents that have been created.
 */
public suspend inline fun IoTAnalyticsClient.listDatasetContents(crossinline block: ListDatasetContentsRequest.Builder.() -> Unit): ListDatasetContentsResponse = listDatasetContents(ListDatasetContentsRequest.Builder().apply(block).build())

/**
 * Retrieves information about datasets.
 */
public suspend inline fun IoTAnalyticsClient.listDatasets(crossinline block: ListDatasetsRequest.Builder.() -> Unit): ListDatasetsResponse = listDatasets(ListDatasetsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of data stores.
 */
public suspend inline fun IoTAnalyticsClient.listDatastores(crossinline block: ListDatastoresRequest.Builder.() -> Unit): ListDatastoresResponse = listDatastores(ListDatastoresRequest.Builder().apply(block).build())

/**
 * Retrieves a list of pipelines.
 */
public suspend inline fun IoTAnalyticsClient.listPipelines(crossinline block: ListPipelinesRequest.Builder.() -> Unit): ListPipelinesResponse = listPipelines(ListPipelinesRequest.Builder().apply(block).build())

/**
 * Lists the tags (metadata) that you have assigned to the resource.
 */
public suspend inline fun IoTAnalyticsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Sets or updates the IoT Analytics logging options.
 *
 * If you update the value of any `loggingOptions` field, it takes up to one minute for the change to take effect. Also, if you change the policy attached to the role you specified in the `roleArn` field (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect.
 */
public suspend inline fun IoTAnalyticsClient.putLoggingOptions(crossinline block: PutLoggingOptionsRequest.Builder.() -> Unit): PutLoggingOptionsResponse = putLoggingOptions(PutLoggingOptionsRequest.Builder().apply(block).build())

/**
 * Simulates the results of running a pipeline activity on a message payload.
 */
public suspend inline fun IoTAnalyticsClient.runPipelineActivity(crossinline block: RunPipelineActivityRequest.Builder.() -> Unit): RunPipelineActivityResponse = runPipelineActivity(RunPipelineActivityRequest.Builder().apply(block).build())

/**
 * Retrieves a sample of messages from the specified channel ingested during the specified timeframe. Up to 10 messages can be retrieved.
 */
public suspend inline fun IoTAnalyticsClient.sampleChannelData(crossinline block: SampleChannelDataRequest.Builder.() -> Unit): SampleChannelDataResponse = sampleChannelData(SampleChannelDataRequest.Builder().apply(block).build())

/**
 * Starts the reprocessing of raw message data through the pipeline.
 */
public suspend inline fun IoTAnalyticsClient.startPipelineReprocessing(crossinline block: StartPipelineReprocessingRequest.Builder.() -> Unit): StartPipelineReprocessingResponse = startPipelineReprocessing(StartPipelineReprocessingRequest.Builder().apply(block).build())

/**
 * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
 */
public suspend inline fun IoTAnalyticsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the given tags (metadata) from the resource.
 */
public suspend inline fun IoTAnalyticsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Used to update the settings of a channel.
 */
public suspend inline fun IoTAnalyticsClient.updateChannel(crossinline block: UpdateChannelRequest.Builder.() -> Unit): UpdateChannelResponse = updateChannel(UpdateChannelRequest.Builder().apply(block).build())

/**
 * Updates the settings of a dataset.
 */
public suspend inline fun IoTAnalyticsClient.updateDataset(crossinline block: UpdateDatasetRequest.Builder.() -> Unit): UpdateDatasetResponse = updateDataset(UpdateDatasetRequest.Builder().apply(block).build())

/**
 * Used to update the settings of a data store.
 */
public suspend inline fun IoTAnalyticsClient.updateDatastore(crossinline block: UpdateDatastoreRequest.Builder.() -> Unit): UpdateDatastoreResponse = updateDatastore(UpdateDatastoreRequest.Builder().apply(block).build())

/**
 * Updates the settings of a pipeline. You must specify both a `channel` and a `datastore` activity and, optionally, as many as 23 additional activities in the `pipelineActivities` array.
 */
public suspend inline fun IoTAnalyticsClient.updatePipeline(crossinline block: UpdatePipelineRequest.Builder.() -> Unit): UpdatePipelineResponse = updatePipeline(UpdatePipelineRequest.Builder().apply(block).build())
