// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a dataset.
 */
public class Dataset private constructor(builder: Builder) {
    /**
     * The `DatasetAction` objects that automatically create the dataset contents.
     */
    public val actions: List<DatasetAction>? = builder.actions
    /**
     * The ARN of the dataset.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * When dataset contents are created they are delivered to destinations specified here.
     */
    public val contentDeliveryRules: List<DatasetContentDeliveryRule>? = builder.contentDeliveryRules
    /**
     * When the dataset was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The last time the dataset was updated.
     */
    public val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTime
    /**
     * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify `lateDataRules`, the dataset must use a [DeltaTimer](https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html) filter.
     */
    public val lateDataRules: List<LateDataRule>? = builder.lateDataRules
    /**
     * The name of the dataset.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Optional. How long, in days, message data is kept for the dataset.
     */
    public val retentionPeriod: aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod? = builder.retentionPeriod
    /**
     * The status of the dataset.
     */
    public val status: aws.sdk.kotlin.services.iotanalytics.model.DatasetStatus? = builder.status
    /**
     * The `DatasetTrigger` objects that specify when the dataset is automatically updated.
     */
    public val triggers: List<DatasetTrigger>? = builder.triggers
    /**
     * Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the `retentionPeriod` parameter. For more information, see [ Keeping Multiple Versions of IoT Analytics datasets](https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions) in the *IoT Analytics User Guide*.
     */
    public val versioningConfiguration: aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration? = builder.versioningConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotanalytics.model.Dataset = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Dataset(")
        append("actions=$actions,")
        append("arn=$arn,")
        append("contentDeliveryRules=$contentDeliveryRules,")
        append("creationTime=$creationTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("lateDataRules=$lateDataRules,")
        append("name=$name,")
        append("retentionPeriod=$retentionPeriod,")
        append("status=$status,")
        append("triggers=$triggers,")
        append("versioningConfiguration=$versioningConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (contentDeliveryRules?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (lateDataRules?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (triggers?.hashCode() ?: 0)
        result = 31 * result + (versioningConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Dataset

        if (actions != other.actions) return false
        if (arn != other.arn) return false
        if (contentDeliveryRules != other.contentDeliveryRules) return false
        if (creationTime != other.creationTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (lateDataRules != other.lateDataRules) return false
        if (name != other.name) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (status != other.status) return false
        if (triggers != other.triggers) return false
        if (versioningConfiguration != other.versioningConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotanalytics.model.Dataset = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `DatasetAction` objects that automatically create the dataset contents.
         */
        public var actions: List<DatasetAction>? = null
        /**
         * The ARN of the dataset.
         */
        public var arn: kotlin.String? = null
        /**
         * When dataset contents are created they are delivered to destinations specified here.
         */
        public var contentDeliveryRules: List<DatasetContentDeliveryRule>? = null
        /**
         * When the dataset was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last time the dataset was updated.
         */
        public var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify `lateDataRules`, the dataset must use a [DeltaTimer](https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html) filter.
         */
        public var lateDataRules: List<LateDataRule>? = null
        /**
         * The name of the dataset.
         */
        public var name: kotlin.String? = null
        /**
         * Optional. How long, in days, message data is kept for the dataset.
         */
        public var retentionPeriod: aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod? = null
        /**
         * The status of the dataset.
         */
        public var status: aws.sdk.kotlin.services.iotanalytics.model.DatasetStatus? = null
        /**
         * The `DatasetTrigger` objects that specify when the dataset is automatically updated.
         */
        public var triggers: List<DatasetTrigger>? = null
        /**
         * Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the `retentionPeriod` parameter. For more information, see [ Keeping Multiple Versions of IoT Analytics datasets](https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions) in the *IoT Analytics User Guide*.
         */
        public var versioningConfiguration: aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotanalytics.model.Dataset) : this() {
            this.actions = x.actions
            this.arn = x.arn
            this.contentDeliveryRules = x.contentDeliveryRules
            this.creationTime = x.creationTime
            this.lastUpdateTime = x.lastUpdateTime
            this.lateDataRules = x.lateDataRules
            this.name = x.name
            this.retentionPeriod = x.retentionPeriod
            this.status = x.status
            this.triggers = x.triggers
            this.versioningConfiguration = x.versioningConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotanalytics.model.Dataset = Dataset(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod] inside the given [block]
         */
        public fun retentionPeriod(block: aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod.Builder.() -> kotlin.Unit) {
            this.retentionPeriod = aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration] inside the given [block]
         */
        public fun versioningConfiguration(block: aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration.Builder.() -> kotlin.Unit) {
            this.versioningConfiguration = aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration.invoke(block)
        }
    }
}
