// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A collection of data from an MQTT topic. Channels archive the raw, unprocessed messages before publishing the data to a pipeline.
 */
public class Channel private constructor(builder: Builder) {
    /**
     * The ARN of the channel.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * When the channel was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The last time when a new message arrived in the channel.
     *
     * IoT Analytics updates this value at most once per minute for one channel. Hence, the `lastMessageArrivalTime` value is an approximation.
     *
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     */
    public val lastMessageArrivalTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastMessageArrivalTime
    /**
     * When the channel was last updated.
     */
    public val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTime
    /**
     * The name of the channel.
     */
    public val name: kotlin.String? = builder.name
    /**
     * How long, in days, message data is kept for the channel.
     */
    public val retentionPeriod: aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod? = builder.retentionPeriod
    /**
     * The status of the channel.
     */
    public val status: aws.sdk.kotlin.services.iotanalytics.model.ChannelStatus? = builder.status
    /**
     * Where channel data is stored. You can choose one of `serviceManagedS3` or `customerManagedS3` storage. If not specified, the default is `serviceManagedS3`. You can't change this storage option after the channel is created.
     */
    public val storage: aws.sdk.kotlin.services.iotanalytics.model.ChannelStorage? = builder.storage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotanalytics.model.Channel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Channel(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("lastMessageArrivalTime=$lastMessageArrivalTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("name=$name,")
        append("retentionPeriod=$retentionPeriod,")
        append("status=$status,")
        append("storage=$storage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastMessageArrivalTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Channel

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (lastMessageArrivalTime != other.lastMessageArrivalTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (name != other.name) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (status != other.status) return false
        if (storage != other.storage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotanalytics.model.Channel = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the channel.
         */
        public var arn: kotlin.String? = null
        /**
         * When the channel was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last time when a new message arrived in the channel.
         *
         * IoT Analytics updates this value at most once per minute for one channel. Hence, the `lastMessageArrivalTime` value is an approximation.
         *
         * This feature only applies to messages that arrived in the data store after October 23, 2020.
         */
        public var lastMessageArrivalTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * When the channel was last updated.
         */
        public var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the channel.
         */
        public var name: kotlin.String? = null
        /**
         * How long, in days, message data is kept for the channel.
         */
        public var retentionPeriod: aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod? = null
        /**
         * The status of the channel.
         */
        public var status: aws.sdk.kotlin.services.iotanalytics.model.ChannelStatus? = null
        /**
         * Where channel data is stored. You can choose one of `serviceManagedS3` or `customerManagedS3` storage. If not specified, the default is `serviceManagedS3`. You can't change this storage option after the channel is created.
         */
        public var storage: aws.sdk.kotlin.services.iotanalytics.model.ChannelStorage? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotanalytics.model.Channel) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.lastMessageArrivalTime = x.lastMessageArrivalTime
            this.lastUpdateTime = x.lastUpdateTime
            this.name = x.name
            this.retentionPeriod = x.retentionPeriod
            this.status = x.status
            this.storage = x.storage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotanalytics.model.Channel = Channel(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod] inside the given [block]
         */
        public fun retentionPeriod(block: aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod.Builder.() -> kotlin.Unit) {
            this.retentionPeriod = aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.ChannelStorage] inside the given [block]
         */
        public fun storage(block: aws.sdk.kotlin.services.iotanalytics.model.ChannelStorage.Builder.() -> kotlin.Unit) {
            this.storage = aws.sdk.kotlin.services.iotanalytics.model.ChannelStorage.invoke(block)
        }
    }
}
