// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickprojects.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object providing detailed information for a particular project associated with an AWS
 * account and region.
 */
class ProjectDescription private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the project.
     */
    val arn: String? = builder.arn
    /**
     * The date when the project was originally created, in UNIX epoch time format.
     */
    val createdDate: Instant? = builder.createdDate
    /**
     * The description of the project.
     */
    val description: String? = builder.description
    /**
     * An object describing the project's placement specifications.
     */
    val placementTemplate: PlacementTemplate? = builder.placementTemplate
    /**
     * The name of the project for which to obtain information from.
     */
    val projectName: String? = builder.projectName
    /**
     * The tags (metadata key/value pairs) associated with the project.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The date when the project was last updated, in UNIX epoch time format. If the project was
     * not updated, then createdDate and updatedDate are the same.
     */
    val updatedDate: Instant? = builder.updatedDate

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ProjectDescription = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ProjectDescription(")
        append("arn=$arn,")
        append("createdDate=$createdDate,")
        append("description=$description,")
        append("placementTemplate=$placementTemplate,")
        append("projectName=$projectName,")
        append("tags=$tags,")
        append("updatedDate=$updatedDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (placementTemplate?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updatedDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ProjectDescription

        if (arn != other.arn) return false
        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (placementTemplate != other.placementTemplate) return false
        if (projectName != other.projectName) return false
        if (tags != other.tags) return false
        if (updatedDate != other.updatedDate) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ProjectDescription = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ProjectDescription
        /**
         * The ARN of the project.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The date when the project was originally created, in UNIX epoch time format.
         */
        fun createdDate(createdDate: Instant): FluentBuilder
        /**
         * The description of the project.
         */
        fun description(description: String): FluentBuilder
        /**
         * An object describing the project's placement specifications.
         */
        fun placementTemplate(placementTemplate: PlacementTemplate): FluentBuilder
        /**
         * The name of the project for which to obtain information from.
         */
        fun projectName(projectName: String): FluentBuilder
        /**
         * The tags (metadata key/value pairs) associated with the project.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The date when the project was last updated, in UNIX epoch time format. If the project was
         * not updated, then createdDate and updatedDate are the same.
         */
        fun updatedDate(updatedDate: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the project.
         */
        var arn: String?
        /**
         * The date when the project was originally created, in UNIX epoch time format.
         */
        var createdDate: Instant?
        /**
         * The description of the project.
         */
        var description: String?
        /**
         * An object describing the project's placement specifications.
         */
        var placementTemplate: PlacementTemplate?
        /**
         * The name of the project for which to obtain information from.
         */
        var projectName: String?
        /**
         * The tags (metadata key/value pairs) associated with the project.
         */
        var tags: Map<String, String>?
        /**
         * The date when the project was last updated, in UNIX epoch time format. If the project was
         * not updated, then createdDate and updatedDate are the same.
         */
        var updatedDate: Instant?

        fun build(): ProjectDescription
        /**
         * construct an [aws.sdk.kotlin.services.iot1clickprojects.model.PlacementTemplate] inside the given [block]
         */
        fun placementTemplate(block: PlacementTemplate.DslBuilder.() -> kotlin.Unit) {
            this.placementTemplate = PlacementTemplate.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var createdDate: Instant? = null
        override var description: String? = null
        override var placementTemplate: PlacementTemplate? = null
        override var projectName: String? = null
        override var tags: Map<String, String>? = null
        override var updatedDate: Instant? = null

        constructor(x: ProjectDescription) : this() {
            this.arn = x.arn
            this.createdDate = x.createdDate
            this.description = x.description
            this.placementTemplate = x.placementTemplate
            this.projectName = x.projectName
            this.tags = x.tags
            this.updatedDate = x.updatedDate
        }

        override fun build(): ProjectDescription = ProjectDescription(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun createdDate(createdDate: Instant): FluentBuilder = apply { this.createdDate = createdDate }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun placementTemplate(placementTemplate: PlacementTemplate): FluentBuilder = apply { this.placementTemplate = placementTemplate }
        override fun projectName(projectName: String): FluentBuilder = apply { this.projectName = projectName }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun updatedDate(updatedDate: Instant): FluentBuilder = apply { this.updatedDate = updatedDate }
    }
}
