// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickprojects.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object providing summary information for a particular placement.
 */
class PlacementSummary private constructor(builder: BuilderImpl) {
    /**
     * The date when the placement was originally created, in UNIX epoch time format.
     */
    val createdDate: Instant? = builder.createdDate
    /**
     * The name of the placement being summarized.
     */
    val placementName: String? = builder.placementName
    /**
     * The name of the project containing the placement.
     */
    val projectName: String? = builder.projectName
    /**
     * The date when the placement was last updated, in UNIX epoch time format. If the placement
     * was not updated, then createdDate and updatedDate are the
     * same.
     */
    val updatedDate: Instant? = builder.updatedDate

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PlacementSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PlacementSummary(")
        append("createdDate=$createdDate,")
        append("placementName=$placementName,")
        append("projectName=$projectName,")
        append("updatedDate=$updatedDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate?.hashCode() ?: 0
        result = 31 * result + (placementName?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        result = 31 * result + (updatedDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PlacementSummary

        if (createdDate != other.createdDate) return false
        if (placementName != other.placementName) return false
        if (projectName != other.projectName) return false
        if (updatedDate != other.updatedDate) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PlacementSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PlacementSummary
        /**
         * The date when the placement was originally created, in UNIX epoch time format.
         */
        fun createdDate(createdDate: Instant): FluentBuilder
        /**
         * The name of the placement being summarized.
         */
        fun placementName(placementName: String): FluentBuilder
        /**
         * The name of the project containing the placement.
         */
        fun projectName(projectName: String): FluentBuilder
        /**
         * The date when the placement was last updated, in UNIX epoch time format. If the placement
         * was not updated, then createdDate and updatedDate are the
         * same.
         */
        fun updatedDate(updatedDate: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date when the placement was originally created, in UNIX epoch time format.
         */
        var createdDate: Instant?
        /**
         * The name of the placement being summarized.
         */
        var placementName: String?
        /**
         * The name of the project containing the placement.
         */
        var projectName: String?
        /**
         * The date when the placement was last updated, in UNIX epoch time format. If the placement
         * was not updated, then createdDate and updatedDate are the
         * same.
         */
        var updatedDate: Instant?

        fun build(): PlacementSummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createdDate: Instant? = null
        override var placementName: String? = null
        override var projectName: String? = null
        override var updatedDate: Instant? = null

        constructor(x: PlacementSummary) : this() {
            this.createdDate = x.createdDate
            this.placementName = x.placementName
            this.projectName = x.projectName
            this.updatedDate = x.updatedDate
        }

        override fun build(): PlacementSummary = PlacementSummary(this)
        override fun createdDate(createdDate: Instant): FluentBuilder = apply { this.createdDate = createdDate }
        override fun placementName(placementName: String): FluentBuilder = apply { this.placementName = placementName }
        override fun projectName(projectName: String): FluentBuilder = apply { this.projectName = projectName }
        override fun updatedDate(updatedDate: Instant): FluentBuilder = apply { this.updatedDate = updatedDate }
    }
}
