// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickprojects.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object describing a project's placement.
 */
class PlacementDescription private constructor(builder: BuilderImpl) {
    /**
     * The user-defined attributes associated with the placement.
     */
    val attributes: Map<String, String>? = builder.attributes
    /**
     * The date when the placement was initially created, in UNIX epoch time format.
     */
    val createdDate: Instant? = builder.createdDate
    /**
     * The name of the placement.
     */
    val placementName: String? = builder.placementName
    /**
     * The name of the project containing the placement.
     */
    val projectName: String? = builder.projectName
    /**
     * The date when the placement was last updated, in UNIX epoch time format. If the placement
     * was not updated, then createdDate and updatedDate are the
     * same.
     */
    val updatedDate: Instant? = builder.updatedDate

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PlacementDescription = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PlacementDescription(")
        append("attributes=$attributes,")
        append("createdDate=$createdDate,")
        append("placementName=$placementName,")
        append("projectName=$projectName,")
        append("updatedDate=$updatedDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (placementName?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        result = 31 * result + (updatedDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PlacementDescription

        if (attributes != other.attributes) return false
        if (createdDate != other.createdDate) return false
        if (placementName != other.placementName) return false
        if (projectName != other.projectName) return false
        if (updatedDate != other.updatedDate) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PlacementDescription = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PlacementDescription
        /**
         * The user-defined attributes associated with the placement.
         */
        fun attributes(attributes: Map<String, String>): FluentBuilder
        /**
         * The date when the placement was initially created, in UNIX epoch time format.
         */
        fun createdDate(createdDate: Instant): FluentBuilder
        /**
         * The name of the placement.
         */
        fun placementName(placementName: String): FluentBuilder
        /**
         * The name of the project containing the placement.
         */
        fun projectName(projectName: String): FluentBuilder
        /**
         * The date when the placement was last updated, in UNIX epoch time format. If the placement
         * was not updated, then createdDate and updatedDate are the
         * same.
         */
        fun updatedDate(updatedDate: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The user-defined attributes associated with the placement.
         */
        var attributes: Map<String, String>?
        /**
         * The date when the placement was initially created, in UNIX epoch time format.
         */
        var createdDate: Instant?
        /**
         * The name of the placement.
         */
        var placementName: String?
        /**
         * The name of the project containing the placement.
         */
        var projectName: String?
        /**
         * The date when the placement was last updated, in UNIX epoch time format. If the placement
         * was not updated, then createdDate and updatedDate are the
         * same.
         */
        var updatedDate: Instant?

        fun build(): PlacementDescription
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attributes: Map<String, String>? = null
        override var createdDate: Instant? = null
        override var placementName: String? = null
        override var projectName: String? = null
        override var updatedDate: Instant? = null

        constructor(x: PlacementDescription) : this() {
            this.attributes = x.attributes
            this.createdDate = x.createdDate
            this.placementName = x.placementName
            this.projectName = x.projectName
            this.updatedDate = x.updatedDate
        }

        override fun build(): PlacementDescription = PlacementDescription(this)
        override fun attributes(attributes: Map<String, String>): FluentBuilder = apply { this.attributes = attributes }
        override fun createdDate(createdDate: Instant): FluentBuilder = apply { this.createdDate = createdDate }
        override fun placementName(placementName: String): FluentBuilder = apply { this.placementName = placementName }
        override fun projectName(projectName: String): FluentBuilder = apply { this.projectName = projectName }
        override fun updatedDate(updatedDate: Instant): FluentBuilder = apply { this.updatedDate = updatedDate }
    }
}
