// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickprojects.model



class CreateProjectRequest private constructor(builder: BuilderImpl) {
    /**
     * An optional description for the project.
     */
    val description: String? = builder.description
    /**
     * The schema defining the placement to be created. A placement template defines placement
     * default attributes and device templates. You cannot add or remove device templates after the
     * project has been created. However, you can update callbackOverrides for the
     * device templates using the UpdateProject API.
     */
    val placementTemplate: PlacementTemplate? = builder.placementTemplate
    /**
     * The name of the project to create.
     */
    val projectName: String? = builder.projectName
    /**
     * Optional tags (metadata key/value pairs) to be associated with the project. For example,
     * { {"key1": "value1", "key2": "value2"} }. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging
     * Strategies.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateProjectRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProjectRequest(")
        append("description=$description,")
        append("placementTemplate=$placementTemplate,")
        append("projectName=$projectName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (placementTemplate?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateProjectRequest

        if (description != other.description) return false
        if (placementTemplate != other.placementTemplate) return false
        if (projectName != other.projectName) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateProjectRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateProjectRequest
        /**
         * An optional description for the project.
         */
        fun description(description: String): FluentBuilder
        /**
         * The schema defining the placement to be created. A placement template defines placement
         * default attributes and device templates. You cannot add or remove device templates after the
         * project has been created. However, you can update callbackOverrides for the
         * device templates using the UpdateProject API.
         */
        fun placementTemplate(placementTemplate: PlacementTemplate): FluentBuilder
        /**
         * The name of the project to create.
         */
        fun projectName(projectName: String): FluentBuilder
        /**
         * Optional tags (metadata key/value pairs) to be associated with the project. For example,
         * { {"key1": "value1", "key2": "value2"} }. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging
         * Strategies.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An optional description for the project.
         */
        var description: String?
        /**
         * The schema defining the placement to be created. A placement template defines placement
         * default attributes and device templates. You cannot add or remove device templates after the
         * project has been created. However, you can update callbackOverrides for the
         * device templates using the UpdateProject API.
         */
        var placementTemplate: PlacementTemplate?
        /**
         * The name of the project to create.
         */
        var projectName: String?
        /**
         * Optional tags (metadata key/value pairs) to be associated with the project. For example,
         * { {"key1": "value1", "key2": "value2"} }. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging
         * Strategies.
         */
        var tags: Map<String, String>?

        fun build(): CreateProjectRequest
        /**
         * construct an [aws.sdk.kotlin.services.iot1clickprojects.model.PlacementTemplate] inside the given [block]
         */
        fun placementTemplate(block: PlacementTemplate.DslBuilder.() -> kotlin.Unit) {
            this.placementTemplate = PlacementTemplate.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var placementTemplate: PlacementTemplate? = null
        override var projectName: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreateProjectRequest) : this() {
            this.description = x.description
            this.placementTemplate = x.placementTemplate
            this.projectName = x.projectName
            this.tags = x.tags
        }

        override fun build(): CreateProjectRequest = CreateProjectRequest(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun placementTemplate(placementTemplate: PlacementTemplate): FluentBuilder = apply { this.placementTemplate = placementTemplate }
        override fun projectName(projectName: String): FluentBuilder = apply { this.projectName = projectName }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
