// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickprojects

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.iot1clickprojects.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iot1clickprojects.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * The AWS IoT 1-Click Projects API Reference
 */
interface Iot1ClickProjectsClient : SdkClient {

    override val serviceName: String
        get() = "IoT 1Click Projects"
    /**
     * Iot1ClickProjectsClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): Iot1ClickProjectsClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultIot1ClickProjectsClient(config)
        }

        operator fun invoke(config: Config): Iot1ClickProjectsClient = DefaultIot1ClickProjectsClient(config)

        /**
         * Construct a [Iot1ClickProjectsClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): Iot1ClickProjectsClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return Iot1ClickProjectsClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: AwsEndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Associates a physical device with a placement.
     */
    suspend fun associateDeviceWithPlacement(input: AssociateDeviceWithPlacementRequest): AssociateDeviceWithPlacementResponse

    /**
     * Associates a physical device with a placement.
     */
    suspend fun associateDeviceWithPlacement(block: AssociateDeviceWithPlacementRequest.DslBuilder.() -> Unit) = associateDeviceWithPlacement(AssociateDeviceWithPlacementRequest.builder().apply(block).build())

    /**
     * Creates an empty placement.
     */
    suspend fun createPlacement(input: CreatePlacementRequest): CreatePlacementResponse

    /**
     * Creates an empty placement.
     */
    suspend fun createPlacement(block: CreatePlacementRequest.DslBuilder.() -> Unit) = createPlacement(CreatePlacementRequest.builder().apply(block).build())

    /**
     * Creates an empty project with a placement template. A project contains zero or more
     * placements that adhere to the placement template defined in the project.
     */
    suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Creates an empty project with a placement template. A project contains zero or more
     * placements that adhere to the placement template defined in the project.
     */
    suspend fun createProject(block: CreateProjectRequest.DslBuilder.() -> Unit) = createProject(CreateProjectRequest.builder().apply(block).build())

    /**
     * Deletes a placement. To delete a placement, it must not have any devices associated with
     * it.
     * When you delete a placement, all associated data becomes irretrievable.
     */
    suspend fun deletePlacement(input: DeletePlacementRequest): DeletePlacementResponse

    /**
     * Deletes a placement. To delete a placement, it must not have any devices associated with
     * it.
     * When you delete a placement, all associated data becomes irretrievable.
     */
    suspend fun deletePlacement(block: DeletePlacementRequest.DslBuilder.() -> Unit) = deletePlacement(DeletePlacementRequest.builder().apply(block).build())

    /**
     * Deletes a project. To delete a project, it must not have any placements associated with
     * it.
     * When you delete a project, all associated data becomes irretrievable.
     */
    suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Deletes a project. To delete a project, it must not have any placements associated with
     * it.
     * When you delete a project, all associated data becomes irretrievable.
     */
    suspend fun deleteProject(block: DeleteProjectRequest.DslBuilder.() -> Unit) = deleteProject(DeleteProjectRequest.builder().apply(block).build())

    /**
     * Describes a placement in a project.
     */
    suspend fun describePlacement(input: DescribePlacementRequest): DescribePlacementResponse

    /**
     * Describes a placement in a project.
     */
    suspend fun describePlacement(block: DescribePlacementRequest.DslBuilder.() -> Unit) = describePlacement(DescribePlacementRequest.builder().apply(block).build())

    /**
     * Returns an object describing a project.
     */
    suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse

    /**
     * Returns an object describing a project.
     */
    suspend fun describeProject(block: DescribeProjectRequest.DslBuilder.() -> Unit) = describeProject(DescribeProjectRequest.builder().apply(block).build())

    /**
     * Removes a physical device from a placement.
     */
    suspend fun disassociateDeviceFromPlacement(input: DisassociateDeviceFromPlacementRequest): DisassociateDeviceFromPlacementResponse

    /**
     * Removes a physical device from a placement.
     */
    suspend fun disassociateDeviceFromPlacement(block: DisassociateDeviceFromPlacementRequest.DslBuilder.() -> Unit) = disassociateDeviceFromPlacement(DisassociateDeviceFromPlacementRequest.builder().apply(block).build())

    /**
     * Returns an object enumerating the devices in a placement.
     */
    suspend fun getDevicesInPlacement(input: GetDevicesInPlacementRequest): GetDevicesInPlacementResponse

    /**
     * Returns an object enumerating the devices in a placement.
     */
    suspend fun getDevicesInPlacement(block: GetDevicesInPlacementRequest.DslBuilder.() -> Unit) = getDevicesInPlacement(GetDevicesInPlacementRequest.builder().apply(block).build())

    /**
     * Lists the placement(s) of a project.
     */
    suspend fun listPlacements(input: ListPlacementsRequest): ListPlacementsResponse

    /**
     * Lists the placement(s) of a project.
     */
    suspend fun listPlacements(block: ListPlacementsRequest.DslBuilder.() -> Unit) = listPlacements(ListPlacementsRequest.builder().apply(block).build())

    /**
     * Lists the AWS IoT 1-Click project(s) associated with your AWS account and region.
     */
    suspend fun listProjects(input: ListProjectsRequest): ListProjectsResponse

    /**
     * Lists the AWS IoT 1-Click project(s) associated with your AWS account and region.
     */
    suspend fun listProjects(block: ListProjectsRequest.DslBuilder.() -> Unit) = listProjects(ListProjectsRequest.builder().apply(block).build())

    /**
     * Lists the tags (metadata key/value pairs) which you have assigned to the resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags (metadata key/value pairs) which you have assigned to the resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Creates or modifies tags for a resource. Tags are key/value pairs (metadata) that can be
     * used to manage a resource. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging
     * Strategies.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Creates or modifies tags for a resource. Tags are key/value pairs (metadata) that can be
     * used to manage a resource. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging
     * Strategies.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Removes one or more tags (metadata key/value pairs) from a resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes one or more tags (metadata key/value pairs) from a resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates a placement with the given attributes. To clear an attribute, pass an empty value
     * (i.e., "").
     */
    suspend fun updatePlacement(input: UpdatePlacementRequest): UpdatePlacementResponse

    /**
     * Updates a placement with the given attributes. To clear an attribute, pass an empty value
     * (i.e., "").
     */
    suspend fun updatePlacement(block: UpdatePlacementRequest.DslBuilder.() -> Unit) = updatePlacement(UpdatePlacementRequest.builder().apply(block).build())

    /**
     * Updates a project associated with your AWS account and region. With the exception of
     * device template names, you can pass just the values that need to be updated because the update
     * request will change only the values that are provided. To clear a value, pass the empty string
     * (i.e., "").
     */
    suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse

    /**
     * Updates a project associated with your AWS account and region. With the exception of
     * device template names, you can pass just the values that need to be updated because the update
     * request will change only the values that are provided. To clear a value, pass the empty string
     * (i.e., "").
     */
    suspend fun updateProject(block: UpdateProjectRequest.DslBuilder.() -> Unit) = updateProject(UpdateProjectRequest.builder().apply(block).build())
}
