// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickprojects

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.services.iot1clickprojects.model.*
import aws.sdk.kotlin.services.iot1clickprojects.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "IoT 1Click Projects"
const val ServiceApiVersion: String = "2018-05-14"
const val SdkVersion: String = "0.9.0-alpha"

internal class DefaultIot1ClickProjectsClient(override val config: Iot1ClickProjectsClient.Config) : Iot1ClickProjectsClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Associates a physical device with a placement.
     */
    override suspend fun associateDeviceWithPlacement(input: AssociateDeviceWithPlacementRequest): AssociateDeviceWithPlacementResponse {
        val op = SdkHttpOperation.build<AssociateDeviceWithPlacementRequest, AssociateDeviceWithPlacementResponse> {
            serializer = AssociateDeviceWithPlacementOperationSerializer()
            deserializer = AssociateDeviceWithPlacementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateDeviceWithPlacement"
            }
        }
        registerAssociateDeviceWithPlacementMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an empty placement.
     */
    override suspend fun createPlacement(input: CreatePlacementRequest): CreatePlacementResponse {
        val op = SdkHttpOperation.build<CreatePlacementRequest, CreatePlacementResponse> {
            serializer = CreatePlacementOperationSerializer()
            deserializer = CreatePlacementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePlacement"
            }
        }
        registerCreatePlacementMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an empty project with a placement template. A project contains zero or more
     * placements that adhere to the placement template defined in the project.
     */
    override suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse {
        val op = SdkHttpOperation.build<CreateProjectRequest, CreateProjectResponse> {
            serializer = CreateProjectOperationSerializer()
            deserializer = CreateProjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateProject"
            }
        }
        registerCreateProjectMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a placement. To delete a placement, it must not have any devices associated with
     * it.
     * When you delete a placement, all associated data becomes irretrievable.
     */
    override suspend fun deletePlacement(input: DeletePlacementRequest): DeletePlacementResponse {
        val op = SdkHttpOperation.build<DeletePlacementRequest, DeletePlacementResponse> {
            serializer = DeletePlacementOperationSerializer()
            deserializer = DeletePlacementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePlacement"
            }
        }
        registerDeletePlacementMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a project. To delete a project, it must not have any placements associated with
     * it.
     * When you delete a project, all associated data becomes irretrievable.
     */
    override suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse {
        val op = SdkHttpOperation.build<DeleteProjectRequest, DeleteProjectResponse> {
            serializer = DeleteProjectOperationSerializer()
            deserializer = DeleteProjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteProject"
            }
        }
        registerDeleteProjectMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Describes a placement in a project.
     */
    override suspend fun describePlacement(input: DescribePlacementRequest): DescribePlacementResponse {
        val op = SdkHttpOperation.build<DescribePlacementRequest, DescribePlacementResponse> {
            serializer = DescribePlacementOperationSerializer()
            deserializer = DescribePlacementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePlacement"
            }
        }
        registerDescribePlacementMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an object describing a project.
     */
    override suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse {
        val op = SdkHttpOperation.build<DescribeProjectRequest, DescribeProjectResponse> {
            serializer = DescribeProjectOperationSerializer()
            deserializer = DescribeProjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProject"
            }
        }
        registerDescribeProjectMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a physical device from a placement.
     */
    override suspend fun disassociateDeviceFromPlacement(input: DisassociateDeviceFromPlacementRequest): DisassociateDeviceFromPlacementResponse {
        val op = SdkHttpOperation.build<DisassociateDeviceFromPlacementRequest, DisassociateDeviceFromPlacementResponse> {
            serializer = DisassociateDeviceFromPlacementOperationSerializer()
            deserializer = DisassociateDeviceFromPlacementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateDeviceFromPlacement"
            }
        }
        registerDisassociateDeviceFromPlacementMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an object enumerating the devices in a placement.
     */
    override suspend fun getDevicesInPlacement(input: GetDevicesInPlacementRequest): GetDevicesInPlacementResponse {
        val op = SdkHttpOperation.build<GetDevicesInPlacementRequest, GetDevicesInPlacementResponse> {
            serializer = GetDevicesInPlacementOperationSerializer()
            deserializer = GetDevicesInPlacementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDevicesInPlacement"
            }
        }
        registerGetDevicesInPlacementMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the placement(s) of a project.
     */
    override suspend fun listPlacements(input: ListPlacementsRequest): ListPlacementsResponse {
        val op = SdkHttpOperation.build<ListPlacementsRequest, ListPlacementsResponse> {
            serializer = ListPlacementsOperationSerializer()
            deserializer = ListPlacementsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPlacements"
            }
        }
        registerListPlacementsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the AWS IoT 1-Click project(s) associated with your AWS account and region.
     */
    override suspend fun listProjects(input: ListProjectsRequest): ListProjectsResponse {
        val op = SdkHttpOperation.build<ListProjectsRequest, ListProjectsResponse> {
            serializer = ListProjectsOperationSerializer()
            deserializer = ListProjectsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProjects"
            }
        }
        registerListProjectsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags (metadata key/value pairs) which you have assigned to the resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates or modifies tags for a resource. Tags are key/value pairs (metadata) that can be
     * used to manage a resource. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging
     * Strategies.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        registerTagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags (metadata key/value pairs) from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        registerUntagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a placement with the given attributes. To clear an attribute, pass an empty value
     * (i.e., "").
     */
    override suspend fun updatePlacement(input: UpdatePlacementRequest): UpdatePlacementResponse {
        val op = SdkHttpOperation.build<UpdatePlacementRequest, UpdatePlacementResponse> {
            serializer = UpdatePlacementOperationSerializer()
            deserializer = UpdatePlacementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePlacement"
            }
        }
        registerUpdatePlacementMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a project associated with your AWS account and region. With the exception of
     * device template names, you can pass just the values that need to be updated because the update
     * request will change only the values that are provided. To clear a value, pass the empty string
     * (i.e., "").
     */
    override suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse {
        val op = SdkHttpOperation.build<UpdateProjectRequest, UpdateProjectResponse> {
            serializer = UpdateProjectOperationSerializer()
            deserializer = UpdateProjectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateProject"
            }
        }
        registerUpdateProjectMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
