// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickprojects.paginators

import aws.sdk.kotlin.services.iot1clickprojects.Iot1ClickProjectsClient
import aws.sdk.kotlin.services.iot1clickprojects.model.ListPlacementsRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.ListPlacementsResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.ListProjectsRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.ListProjectsResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.PlacementSummary
import aws.sdk.kotlin.services.iot1clickprojects.model.ProjectSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListPlacementsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPlacementsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlacementsResponse]
 */
public fun Iot1ClickProjectsClient.listPlacementsPaginated(initialRequest: ListPlacementsRequest): Flow<ListPlacementsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPlacementsPaginated.listPlacements(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPlacementsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlacementsResponse]
 */
public fun Iot1ClickProjectsClient.listPlacementsPaginated(block: ListPlacementsRequest.Builder.() -> Unit): Flow<ListPlacementsResponse> =
    listPlacementsPaginated(ListPlacementsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPlacementsPaginated]
 * to access the nested member [PlacementSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PlacementSummary]
 */
@JvmName("listPlacementsResponsePlacementSummary")
public fun Flow<ListPlacementsResponse>.placements(): Flow<PlacementSummary> =
    transform() { response ->
        response.placements?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProjectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectsResponse]
 */
public fun Iot1ClickProjectsClient.listProjectsPaginated(initialRequest: ListProjectsRequest = ListProjectsRequest { }): Flow<ListProjectsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProjectsPaginated.listProjects(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectsResponse]
 */
public fun Iot1ClickProjectsClient.listProjectsPaginated(block: ListProjectsRequest.Builder.() -> Unit): Flow<ListProjectsResponse> =
    listProjectsPaginated(ListProjectsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProjectsPaginated]
 * to access the nested member [ProjectSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProjectSummary]
 */
@JvmName("listProjectsResponseProjectSummary")
public fun Flow<ListProjectsResponse>.projects(): Flow<ProjectSummary> =
    transform() { response ->
        response.projects?.forEach {
            emit(it)
        }
    }
