// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickprojects.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object providing detailed information for a particular project associated with an AWS account and region.
 */
public class ProjectDescription private constructor(builder: Builder) {
    /**
     * The ARN of the project.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date when the project was originally created, in UNIX epoch time format.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdDate) { "A non-null value must be provided for createdDate" }
    /**
     * The description of the project.
     */
    public val description: kotlin.String? = builder.description
    /**
     * An object describing the project's placement specifications.
     */
    public val placementTemplate: aws.sdk.kotlin.services.iot1clickprojects.model.PlacementTemplate? = builder.placementTemplate
    /**
     * The name of the project for which to obtain information from.
     */
    public val projectName: kotlin.String = requireNotNull(builder.projectName) { "A non-null value must be provided for projectName" }
    /**
     * The tags (metadata key/value pairs) associated with the project.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The date when the project was last updated, in UNIX epoch time format. If the project was not updated, then `createdDate` and `updatedDate` are the same.
     */
    public val updatedDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedDate) { "A non-null value must be provided for updatedDate" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot1clickprojects.model.ProjectDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProjectDescription(")
        append("arn=$arn,")
        append("createdDate=$createdDate,")
        append("description=$description,")
        append("placementTemplate=$placementTemplate,")
        append("projectName=$projectName,")
        append("tags=$tags,")
        append("updatedDate=$updatedDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdDate.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (placementTemplate?.hashCode() ?: 0)
        result = 31 * result + (projectName.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updatedDate.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProjectDescription

        if (arn != other.arn) return false
        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (placementTemplate != other.placementTemplate) return false
        if (projectName != other.projectName) return false
        if (tags != other.tags) return false
        if (updatedDate != other.updatedDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot1clickprojects.model.ProjectDescription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the project.
         */
        public var arn: kotlin.String? = null
        /**
         * The date when the project was originally created, in UNIX epoch time format.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the project.
         */
        public var description: kotlin.String? = null
        /**
         * An object describing the project's placement specifications.
         */
        public var placementTemplate: aws.sdk.kotlin.services.iot1clickprojects.model.PlacementTemplate? = null
        /**
         * The name of the project for which to obtain information from.
         */
        public var projectName: kotlin.String? = null
        /**
         * The tags (metadata key/value pairs) associated with the project.
         */
        public var tags: Map<String, String>? = null
        /**
         * The date when the project was last updated, in UNIX epoch time format. If the project was not updated, then `createdDate` and `updatedDate` are the same.
         */
        public var updatedDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot1clickprojects.model.ProjectDescription) : this() {
            this.arn = x.arn
            this.createdDate = x.createdDate
            this.description = x.description
            this.placementTemplate = x.placementTemplate
            this.projectName = x.projectName
            this.tags = x.tags
            this.updatedDate = x.updatedDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot1clickprojects.model.ProjectDescription = ProjectDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot1clickprojects.model.PlacementTemplate] inside the given [block]
         */
        public fun placementTemplate(block: aws.sdk.kotlin.services.iot1clickprojects.model.PlacementTemplate.Builder.() -> kotlin.Unit) {
            this.placementTemplate = aws.sdk.kotlin.services.iot1clickprojects.model.PlacementTemplate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdDate == null) createdDate = Instant.fromEpochSeconds(0)
            if (projectName == null) projectName = ""
            if (updatedDate == null) updatedDate = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
