// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickprojects.endpoints



/**
 * The set of values necessary for endpoint resolution.
 */
public class Iot1ClickProjectsEndpointParameters private constructor(builder: Builder) {
    /**
     * Override the endpoint used to send this request
     */
    public val endpoint: String? = builder.endpoint

    /**
     * The AWS region used to dispatch the request.
     */
    public val region: String? = builder.region

    /**
     * When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
     */
    public val useDualStack: Boolean? = requireNotNull(builder.useDualStack) { "endpoint provider parameter #useDualStack is required" }

    /**
     * When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
     */
    public val useFips: Boolean? = requireNotNull(builder.useFips) { "endpoint provider parameter #useFips is required" }

    public companion object {
        public inline operator fun invoke(block: Builder.() -> Unit): Iot1ClickProjectsEndpointParameters = Builder().apply(block).build()
    }

    public override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is Iot1ClickProjectsEndpointParameters) return false
        if (this.endpoint != other.endpoint) return false
        if (this.region != other.region) return false
        if (this.useDualStack != other.useDualStack) return false
        if (this.useFips != other.useFips) return false
        return true
    }

    public override fun hashCode(): Int {
        var result = endpoint?.hashCode() ?: 0
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (useDualStack?.hashCode() ?: 0)
        result = 31 * result + (useFips?.hashCode() ?: 0)
        return result
    }

    public override fun toString(): String = buildString {
        append("Iot1ClickProjectsEndpointParameters(")
        append("endpoint=$endpoint,")
        append("region=$region,")
        append("useDualStack=$useDualStack,")
        append("useFips=$useFips)")
    }

    public fun copy(block: Builder.() -> Unit = {}): Iot1ClickProjectsEndpointParameters {
        return Builder().apply {
            endpoint = this@Iot1ClickProjectsEndpointParameters.endpoint
            region = this@Iot1ClickProjectsEndpointParameters.region
            useDualStack = this@Iot1ClickProjectsEndpointParameters.useDualStack
            useFips = this@Iot1ClickProjectsEndpointParameters.useFips
            block()
        }
        .build()
    }

    public class Builder {
        /**
         * Override the endpoint used to send this request
         */
        public var endpoint: String? = null

        /**
         * The AWS region used to dispatch the request.
         */
        public var region: String? = null

        /**
         * When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
         */
        public var useDualStack: Boolean? = false

        /**
         * When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
         */
        public var useFips: Boolean? = false

        public fun build(): Iot1ClickProjectsEndpointParameters = Iot1ClickProjectsEndpointParameters(this)
    }
}
