// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickprojects.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object providing summary information for a particular placement.
 */
public class PlacementSummary private constructor(builder: Builder) {
    /**
     * The date when the placement was originally created, in UNIX epoch time format.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdDate) { "A non-null value must be provided for createdDate" }
    /**
     * The name of the placement being summarized.
     */
    public val placementName: kotlin.String = requireNotNull(builder.placementName) { "A non-null value must be provided for placementName" }
    /**
     * The name of the project containing the placement.
     */
    public val projectName: kotlin.String = requireNotNull(builder.projectName) { "A non-null value must be provided for projectName" }
    /**
     * The date when the placement was last updated, in UNIX epoch time format. If the placement was not updated, then `createdDate` and `updatedDate` are the same.
     */
    public val updatedDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedDate) { "A non-null value must be provided for updatedDate" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot1clickprojects.model.PlacementSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PlacementSummary(")
        append("createdDate=$createdDate,")
        append("placementName=$placementName,")
        append("projectName=$projectName,")
        append("updatedDate=$updatedDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate.hashCode()
        result = 31 * result + (placementName.hashCode())
        result = 31 * result + (projectName.hashCode())
        result = 31 * result + (updatedDate.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PlacementSummary

        if (createdDate != other.createdDate) return false
        if (placementName != other.placementName) return false
        if (projectName != other.projectName) return false
        if (updatedDate != other.updatedDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot1clickprojects.model.PlacementSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date when the placement was originally created, in UNIX epoch time format.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the placement being summarized.
         */
        public var placementName: kotlin.String? = null
        /**
         * The name of the project containing the placement.
         */
        public var projectName: kotlin.String? = null
        /**
         * The date when the placement was last updated, in UNIX epoch time format. If the placement was not updated, then `createdDate` and `updatedDate` are the same.
         */
        public var updatedDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot1clickprojects.model.PlacementSummary) : this() {
            this.createdDate = x.createdDate
            this.placementName = x.placementName
            this.projectName = x.projectName
            this.updatedDate = x.updatedDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot1clickprojects.model.PlacementSummary = PlacementSummary(this)

        internal fun correctErrors(): Builder {
            if (createdDate == null) createdDate = Instant.fromEpochSeconds(0)
            if (placementName == null) placementName = ""
            if (projectName == null) projectName = ""
            if (updatedDate == null) updatedDate = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
