// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot1clickprojects

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.iot1clickprojects.auth.DefaultIot1ClickProjectsAuthSchemeProvider
import aws.sdk.kotlin.services.iot1clickprojects.auth.Iot1ClickProjectsAuthSchemeProvider
import aws.sdk.kotlin.services.iot1clickprojects.endpoints.DefaultIot1ClickProjectsEndpointProvider
import aws.sdk.kotlin.services.iot1clickprojects.endpoints.Iot1ClickProjectsEndpointParameters
import aws.sdk.kotlin.services.iot1clickprojects.endpoints.Iot1ClickProjectsEndpointProvider
import aws.sdk.kotlin.services.iot1clickprojects.model.AssociateDeviceWithPlacementRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.AssociateDeviceWithPlacementResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.CreatePlacementRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.CreatePlacementResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.CreateProjectRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.CreateProjectResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.DeletePlacementRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.DeletePlacementResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.DeleteProjectRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.DeleteProjectResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.DescribePlacementRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.DescribePlacementResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.DescribeProjectRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.DescribeProjectResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.DisassociateDeviceFromPlacementResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.GetDevicesInPlacementRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.GetDevicesInPlacementResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.ListPlacementsRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.ListPlacementsResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.ListProjectsRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.ListProjectsResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.TagResourceRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.TagResourceResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.UntagResourceRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.UntagResourceResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.UpdatePlacementRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.UpdatePlacementResponse
import aws.sdk.kotlin.services.iot1clickprojects.model.UpdateProjectRequest
import aws.sdk.kotlin.services.iot1clickprojects.model.UpdateProjectResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "IoT 1Click Projects"
public const val SdkVersion: String = "1.0.27"
public const val ServiceApiVersion: String = "2018-05-14"

/**
 * The AWS IoT 1-Click Projects API Reference
 */
public interface Iot1ClickProjectsClient : SdkClient {
    /**
     * Iot1ClickProjectsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, Iot1ClickProjectsClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Iot1ClickProjects",
                "IOT_1CLICK_PROJECTS",
                "iot_1click_projects",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, Iot1ClickProjectsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): Iot1ClickProjectsClient = DefaultIot1ClickProjectsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: Iot1ClickProjectsEndpointProvider = builder.endpointProvider ?: DefaultIot1ClickProjectsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: Iot1ClickProjectsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultIot1ClickProjectsAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "IoT 1Click Projects"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: Iot1ClickProjectsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: Iot1ClickProjectsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a physical device with a placement.
     */
    public suspend fun associateDeviceWithPlacement(input: AssociateDeviceWithPlacementRequest): AssociateDeviceWithPlacementResponse

    /**
     * Creates an empty placement.
     */
    public suspend fun createPlacement(input: CreatePlacementRequest): CreatePlacementResponse

    /**
     * Creates an empty project with a placement template. A project contains zero or more placements that adhere to the placement template defined in the project.
     */
    public suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Deletes a placement. To delete a placement, it must not have any devices associated with it.
     *
     * When you delete a placement, all associated data becomes irretrievable.
     */
    public suspend fun deletePlacement(input: DeletePlacementRequest): DeletePlacementResponse

    /**
     * Deletes a project. To delete a project, it must not have any placements associated with it.
     *
     * When you delete a project, all associated data becomes irretrievable.
     */
    public suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Describes a placement in a project.
     */
    public suspend fun describePlacement(input: DescribePlacementRequest): DescribePlacementResponse

    /**
     * Returns an object describing a project.
     */
    public suspend fun describeProject(input: DescribeProjectRequest): DescribeProjectResponse

    /**
     * Removes a physical device from a placement.
     */
    public suspend fun disassociateDeviceFromPlacement(input: DisassociateDeviceFromPlacementRequest): DisassociateDeviceFromPlacementResponse

    /**
     * Returns an object enumerating the devices in a placement.
     */
    public suspend fun getDevicesInPlacement(input: GetDevicesInPlacementRequest): GetDevicesInPlacementResponse

    /**
     * Lists the placement(s) of a project.
     */
    public suspend fun listPlacements(input: ListPlacementsRequest): ListPlacementsResponse

    /**
     * Lists the AWS IoT 1-Click project(s) associated with your AWS account and region.
     */
    public suspend fun listProjects(input: ListProjectsRequest = ListProjectsRequest { }): ListProjectsResponse

    /**
     * Lists the tags (metadata key/value pairs) which you have assigned to the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates or modifies tags for a resource. Tags are key/value pairs (metadata) that can be used to manage a resource. For more information, see [AWS Tagging Strategies](https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags (metadata key/value pairs) from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a placement with the given attributes. To clear an attribute, pass an empty value (i.e., "").
     */
    public suspend fun updatePlacement(input: UpdatePlacementRequest): UpdatePlacementResponse

    /**
     * Updates a project associated with your AWS account and region. With the exception of device template names, you can pass just the values that need to be updated because the update request will change only the values that are provided. To clear a value, pass the empty string (i.e., `""`).
     */
    public suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun Iot1ClickProjectsClient.withConfig(block: Iot1ClickProjectsClient.Config.Builder.() -> Unit): Iot1ClickProjectsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIot1ClickProjectsClient(newConfig)
}

/**
 * Associates a physical device with a placement.
 */
public suspend inline fun Iot1ClickProjectsClient.associateDeviceWithPlacement(crossinline block: AssociateDeviceWithPlacementRequest.Builder.() -> Unit): AssociateDeviceWithPlacementResponse = associateDeviceWithPlacement(AssociateDeviceWithPlacementRequest.Builder().apply(block).build())

/**
 * Creates an empty placement.
 */
public suspend inline fun Iot1ClickProjectsClient.createPlacement(crossinline block: CreatePlacementRequest.Builder.() -> Unit): CreatePlacementResponse = createPlacement(CreatePlacementRequest.Builder().apply(block).build())

/**
 * Creates an empty project with a placement template. A project contains zero or more placements that adhere to the placement template defined in the project.
 */
public suspend inline fun Iot1ClickProjectsClient.createProject(crossinline block: CreateProjectRequest.Builder.() -> Unit): CreateProjectResponse = createProject(CreateProjectRequest.Builder().apply(block).build())

/**
 * Deletes a placement. To delete a placement, it must not have any devices associated with it.
 *
 * When you delete a placement, all associated data becomes irretrievable.
 */
public suspend inline fun Iot1ClickProjectsClient.deletePlacement(crossinline block: DeletePlacementRequest.Builder.() -> Unit): DeletePlacementResponse = deletePlacement(DeletePlacementRequest.Builder().apply(block).build())

/**
 * Deletes a project. To delete a project, it must not have any placements associated with it.
 *
 * When you delete a project, all associated data becomes irretrievable.
 */
public suspend inline fun Iot1ClickProjectsClient.deleteProject(crossinline block: DeleteProjectRequest.Builder.() -> Unit): DeleteProjectResponse = deleteProject(DeleteProjectRequest.Builder().apply(block).build())

/**
 * Describes a placement in a project.
 */
public suspend inline fun Iot1ClickProjectsClient.describePlacement(crossinline block: DescribePlacementRequest.Builder.() -> Unit): DescribePlacementResponse = describePlacement(DescribePlacementRequest.Builder().apply(block).build())

/**
 * Returns an object describing a project.
 */
public suspend inline fun Iot1ClickProjectsClient.describeProject(crossinline block: DescribeProjectRequest.Builder.() -> Unit): DescribeProjectResponse = describeProject(DescribeProjectRequest.Builder().apply(block).build())

/**
 * Removes a physical device from a placement.
 */
public suspend inline fun Iot1ClickProjectsClient.disassociateDeviceFromPlacement(crossinline block: DisassociateDeviceFromPlacementRequest.Builder.() -> Unit): DisassociateDeviceFromPlacementResponse = disassociateDeviceFromPlacement(DisassociateDeviceFromPlacementRequest.Builder().apply(block).build())

/**
 * Returns an object enumerating the devices in a placement.
 */
public suspend inline fun Iot1ClickProjectsClient.getDevicesInPlacement(crossinline block: GetDevicesInPlacementRequest.Builder.() -> Unit): GetDevicesInPlacementResponse = getDevicesInPlacement(GetDevicesInPlacementRequest.Builder().apply(block).build())

/**
 * Lists the placement(s) of a project.
 */
public suspend inline fun Iot1ClickProjectsClient.listPlacements(crossinline block: ListPlacementsRequest.Builder.() -> Unit): ListPlacementsResponse = listPlacements(ListPlacementsRequest.Builder().apply(block).build())

/**
 * Lists the AWS IoT 1-Click project(s) associated with your AWS account and region.
 */
public suspend inline fun Iot1ClickProjectsClient.listProjects(crossinline block: ListProjectsRequest.Builder.() -> Unit): ListProjectsResponse = listProjects(ListProjectsRequest.Builder().apply(block).build())

/**
 * Lists the tags (metadata key/value pairs) which you have assigned to the resource.
 */
public suspend inline fun Iot1ClickProjectsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates or modifies tags for a resource. Tags are key/value pairs (metadata) that can be used to manage a resource. For more information, see [AWS Tagging Strategies](https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
 */
public suspend inline fun Iot1ClickProjectsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags (metadata key/value pairs) from a resource.
 */
public suspend inline fun Iot1ClickProjectsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a placement with the given attributes. To clear an attribute, pass an empty value (i.e., "").
 */
public suspend inline fun Iot1ClickProjectsClient.updatePlacement(crossinline block: UpdatePlacementRequest.Builder.() -> Unit): UpdatePlacementResponse = updatePlacement(UpdatePlacementRequest.Builder().apply(block).build())

/**
 * Updates a project associated with your AWS account and region. With the exception of device template names, you can pass just the values that need to be updated because the update request will change only the values that are provided. To clear a value, pass the empty string (i.e., `""`).
 */
public suspend inline fun Iot1ClickProjectsClient.updateProject(crossinline block: UpdateProjectRequest.Builder.() -> Unit): UpdateProjectResponse = updateProject(UpdateProjectRequest.Builder().apply(block).build())
